/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.favourite.user.bs.messaging.helper;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.client.CatalogBsClient;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.dto.OutputFavouriteUserItemDto;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.dto.catalog.OutputItemDto;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.enums.ItemContext;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.mapper.FavouriteItemMapper;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.messaging.dto.CatalogItemMessagingStatusAdditionalDataDto;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.messaging.dto.FavouriteItemMessageBodyDto;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.messaging.dto.InstitutionalPageStatusChangeNotificationData;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.messaging.helper.MessagingHelper;
import io.micrometer.common.util.StringUtils;
import java.lang.runtime.SwitchBootstraps;
import java.time.Instant;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class MessagingHelper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MessagingHelper.class);
    private final CatalogBsClient catalogBsClient;
    private final FavouriteItemMapper favouriteItemMapper;
    private final ObjectMapper objectMapper;

    public FavouriteItemMessageBodyDto buildFavouriteItemMessage(OutputFavouriteUserItemDto favouriteItem) {
        ItemData data = this.getData(favouriteItem);
        return this.favouriteItemMapper.toFavouriteItemMessageBodyDto(favouriteItem, data.name(), data.title(), data.owner() != null ? List.of(data.owner()) : List.of(), Instant.now());
    }

    public CatalogItemMessagingStatusAdditionalDataDto convertToCatalogItemMessagingStatusAdditionalDataDto(Object additionalData) {
        return (CatalogItemMessagingStatusAdditionalDataDto)this.convertData(additionalData, CatalogItemMessagingStatusAdditionalDataDto.class, "Failed to convert additional data to CatalogItemMessagingStatusAdditionalDataDto");
    }

    public InstitutionalPageStatusChangeNotificationData convertToInstitutionalPageStatusChangeNotificationData(Object additionalData) {
        return (InstitutionalPageStatusChangeNotificationData)this.convertData(additionalData, InstitutionalPageStatusChangeNotificationData.class, "Failed to convert additional data to InstitutionalPageStatusChangeNotificationData");
    }

    @NonNull
    private ItemData getData(OutputFavouriteUserItemDto favouriteItem) {
        ItemContext itemContext = favouriteItem.getContext();
        int n = 0;
        ItemData data = switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"CATALOG"}, (ItemContext)itemContext, n)) {
            case 0 -> this.getCatalogItemData(favouriteItem.getItemId());
            default -> null;
        };
        return data != null ? data : ItemData.builder().build();
    }

    private ItemData getCatalogItemData(String itemId) {
        if (StringUtils.isBlank((String)itemId)) {
            return null;
        }
        try {
            OutputItemDto item = this.catalogBsClient.getItemById(itemId);
            return ItemData.builder().title(item.getTitle()).owner(item.getMaintainer().getEmail()).build();
        }
        catch (Exception e) {
            log.error("Error retrieving catalog item name, fallback to id", (Throwable)e);
            return null;
        }
    }

    private <T> T convertData(Object additionalData, Class<T> targetType, String errorMessage) {
        try {
            return (T)this.objectMapper.convertValue(additionalData, targetType);
        }
        catch (IllegalArgumentException e) {
            log.error("{}: {}", new Object[]{errorMessage, additionalData, e});
            throw new IllegalArgumentException("Invalid additional data format", e);
        }
    }

    @Generated
    public MessagingHelper(CatalogBsClient catalogBsClient, FavouriteItemMapper favouriteItemMapper, ObjectMapper objectMapper) {
        this.catalogBsClient = catalogBsClient;
        this.favouriteItemMapper = favouriteItemMapper;
        this.objectMapper = objectMapper;
    }
}

