package com.finconsgroup.itserr.marketplace.favourite.user.bs.client;


import com.finconsgroup.itserr.marketplace.core.web.dto.OutputPageDto;
import com.finconsgroup.itserr.marketplace.core.web.enums.SortDirection;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.dto.InputFindFavouriteDetailDto;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.dto.search.OutputCatalogFavouriteDto;
import jakarta.validation.constraints.Positive;
import jakarta.validation.constraints.PositiveOrZero;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * Feign Client interface for Search Domain Service
 */
public interface SearchDmClient {

    /**
     * Retrieves a limited list of favourite results matching the provided terms and filters from Catalog Search index.
     *
     * @param dto        the input data transfer object containing favourite search details
     * @param filters    the additional filters to apply in the format key1=value1,value2&key2=value3,value4
     * @param pageNumber the page number to retrieve (default is 0)
     * @param pageSize   the number of catalog documents per page (default is 10)
     * @param sort       the field to sort by (default is "relevance")
     * @param direction  the direction of sorting (default is ascending)
     * @return a {@link OutputPageDto<OutputCatalogFavouriteDto>} and HTTP status 200 (OK)
     */
    @PostMapping("/catalog/favourite")
    OutputPageDto<OutputCatalogFavouriteDto> getFavourite(
        @RequestBody InputFindFavouriteDetailDto dto,
        @RequestParam(value = "filters", required = false) String filters,
        @RequestParam(name = "pageNumber", defaultValue = "0", required = false) @PositiveOrZero int pageNumber,
        @RequestParam(name = "pageSize", defaultValue = "10", required = false) @Positive int pageSize,
        @RequestParam(name = "sort", defaultValue = "relevance", required = false) String sort,
        @RequestParam(name = "direction", defaultValue = "DESC", required = false) SortDirection direction
    );
}
