package com.finconsgroup.itserr.marketplace.favourite.user.bs.dto.institutionalpage;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.UUID;

/**
 * Output DTO representing a user for institutional page.
 */
@Schema(name = "OutputInstitutionalPageContributorDto", description = "DTO representing a user for institutional page")
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class OutputInstitutionalPageUserProfileDto {

    @Schema(description = "Unique identifier of the user profile", example = "550e8400-e29b-41d4-a716-446655440000")
    private UUID id;

    @Schema(description = "First name of the user", example = "John")
    private String firstName;

    @Schema(description = "Last name of the user", example = "Doe")
    private String lastName;

    @Schema(description = "Link of the image of user", example = "https://imageLink")
    private String imageUrl;

    @Schema(description = "orcid", example = "00000-00000-00000-00000")
    private String orcid;

}
