/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.favourite.user.bs.api;

import com.finconsgroup.itserr.marketplace.core.web.dto.OutputPageDto;
import com.finconsgroup.itserr.marketplace.core.web.enums.SortDirection;
import com.finconsgroup.itserr.marketplace.core.web.validation.annotation.ValidPutIdParameters;
import com.finconsgroup.itserr.marketplace.core.web.validation.annotation.ValidQueryFilter;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.dto.FavouriteUserItemDetail;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.dto.InputCreateFavouriteUserItemDto;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.dto.InputPatchFavouriteUserItemDto;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.dto.OutputFavouriteUserItemDetailDto;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.dto.OutputFavouriteUserItemDto;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.enums.ItemContext;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.Positive;
import jakarta.validation.constraints.PositiveOrZero;
import jakarta.validation.constraints.Size;
import java.util.List;
import java.util.UUID;
import org.springframework.http.HttpStatus;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;

@Tag(name="Favourite User Items", description="Operations related to favourite user items")
@SecurityRequirement(name="BearerAuth")
@ApiResponses(value={@ApiResponse(responseCode="401", ref="Unauthorized"), @ApiResponse(responseCode="500", ref="InternalServerError")})
@Validated
public interface FavouriteUserItemApi {
    @Operation(summary="Create new favourite user item", description="Create a new favourite user item for the given context based onthe provided dto. It also performs validations and returns errors in case of validation failures")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="OK"), @ApiResponse(responseCode="400", ref="BadRequest")})
    @ResponseStatus(value=HttpStatus.CREATED)
    @PostMapping(value={"/favourite-user/items"}, consumes={"application/json"}, produces={"application/json"})
    public OutputFavouriteUserItemDto create(@Valid @RequestBody InputCreateFavouriteUserItemDto var1);

    @Operation(summary="Fetches favourite user item for the provided id", description="Fetches a favourite user item using the provided id.It returns not found response in case if the id does not exist")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", ref="NotFound")})
    @ResponseStatus(value=HttpStatus.OK)
    @GetMapping(value={"/favourite-user/items/{favouriteUserItemId}"}, produces={"application/json"})
    public OutputFavouriteUserItemDetailDto<?> get(@PathVariable(value="favouriteUserItemId") UUID var1);

    @Operation(summary="Deletes favourite user item for the provided id", description="Deletes a favourite user item using the provided id.It returns not found response in case if the id does not exist")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="404", ref="NotFound")})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @DeleteMapping(value={"/favourite-user/items/{favouriteUserItemId}"})
    public void delete(@PathVariable(value="favouriteUserItemId") UUID var1);

    @Operation(summary="Updates an existing favourite user item", description="Updates only the provided fields of favourite user item based on the provided dto. It also performs validations and returns errors in case of validation failures")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="400", ref="BadRequest"), @ApiResponse(responseCode="404", ref="NotFound")})
    @ResponseStatus(value=HttpStatus.OK)
    @PatchMapping(value={"/favourite-user/items/{favouriteUserItemId}"}, produces={"application/json"}, consumes={"application/json"})
    @ValidPutIdParameters(pathIdParam="favouriteUserItemId")
    public OutputFavouriteUserItemDto patch(@PathVariable(value="favouriteUserItemId") UUID var1, @Valid @RequestBody InputPatchFavouriteUserItemDto var2);

    @Operation(summary="Retrieve all favourite user items matching the provided context", parameters={@Parameter(name="context", description="The context to search favourite user items for"), @Parameter(name="subContext", description="The sub context to search favourite user items for"), @Parameter(name="pageNumber", description="The page index, starting from 0"), @Parameter(name="pageSize", description="The number of items per page"), @Parameter(name="sort", description="The field by which to sort the results"), @Parameter(name="direction", description="The sorting direction: ASC or DESC"), @Parameter(name="filters", description="The additional filters to apply in the format key1=value1,value2&key2=value3,value4")}, responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="400", ref="BadRequest")})
    @ResponseStatus(value=HttpStatus.OK)
    @GetMapping(value={"/favourite-user/items"}, produces={"application/json"})
    public OutputPageDto<OutputFavouriteUserItemDetailDto<FavouriteUserItemDetail>> findByContext(@RequestParam(name="context") ItemContext var1, @RequestParam(name="subContext", required=false) String var2, @RequestParam(name="pageNumber", defaultValue="0", required=false) @PositiveOrZero int var3, @RequestParam(name="pageSize", defaultValue="10", required=false) @Positive int var4, @RequestParam(name="sort", defaultValue="id", required=false) String var5, @RequestParam(name="direction", defaultValue="ASC", required=false) SortDirection var6, @RequestParam(name="filters", required=false) @ValidQueryFilter String var7);

    @Operation(summary="Retrieve all favourite user items matching the provided context", parameters={@Parameter(name="context", description="The context to search favourite user items for"), @Parameter(name="subContext", description="The sub context to search favourite user items for"), @Parameter(name="itemIds", description="The items ids separated by a separator"), @Parameter(name="itemIdSeparator", description="The item id separator, default if comma i.e ','")}, responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="400", ref="BadRequest")})
    @ResponseStatus(value=HttpStatus.OK)
    @GetMapping(value={"/favourite-user/items-by-item-ids"}, produces={"application/json"})
    public List<OutputFavouriteUserItemDto> findByContextAndItemIds(@RequestParam(name="context") ItemContext var1, @RequestParam(name="subContext", required=false) String var2, @NotBlank @RequestParam(name="itemIds") String var3, @Size(min=1) @RequestParam(name="itemIdSeparator", required=false, defaultValue=",") @Size(min=1) String var4);
}

