/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.favourite.user.bs.messaging.impl;

import com.finconsgroup.itserr.marketplace.favourite.user.bs.enums.ItemContext;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.messaging.EventProducer;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.messaging.config.properties.MessagingConfigurationProperties;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.messaging.dto.FavouriteItemMessageBodyDto;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.messaging.dto.ResourceByFolloweeMessageBodyDto;
import com.finconsgroup.itserr.messaging.exception.WP2MessagingException;
import com.finconsgroup.itserr.messaging.producer.MessageProducer;
import com.finconsgroup.itserr.messaging.producer.ProducerRegistry;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(name={"messaging.enabled"}, havingValue="true")
public class DefaultEventProducer
implements EventProducer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultEventProducer.class);
    private final MessageProducer messageProducer;
    private final MessagingConfigurationProperties messagingProperties;

    public DefaultEventProducer(MessagingConfigurationProperties messagingConfigurationProperties, ProducerRegistry producerRegistry) {
        this.messagingProperties = messagingConfigurationProperties;
        this.messageProducer = producerRegistry.getMessageProducer(this.messagingProperties.getEventProducerName());
    }

    public void publishFavouriteItemCreatedEvent(@NonNull FavouriteItemMessageBodyDto favouriteItem) {
        this.publish(favouriteItem.getId(), (Object)favouriteItem, this.messagingProperties.getFavouriteItemCreatedEventType());
    }

    public void publishFavouriteItemUpdatedEvent(@NonNull FavouriteItemMessageBodyDto favouriteItem) {
        this.publish(favouriteItem.getId(), (Object)favouriteItem, this.messagingProperties.getFavouriteItemUpdatedEventType());
    }

    public void publishFavouriteItemDeletedEvent(@NonNull FavouriteItemMessageBodyDto favouriteItem) {
        this.publish(favouriteItem.getId(), (Object)favouriteItem, this.messagingProperties.getFavouriteItemDeletedEventType());
    }

    public void publishResourceCreatedByFolloweeEvent(@NonNull ResourceByFolloweeMessageBodyDto resourceByFollowee) {
        String itemContext = ((ResourceByFolloweeMessageBodyDto.AdditionalData)resourceByFollowee.getAdditionalData()).getItemContext();
        String eventType = null;
        if (ItemContext.CATALOG.getId().equalsIgnoreCase(itemContext)) {
            eventType = this.messagingProperties.getFavouriteItemFolloweeCatalogCreatedEventType();
        } else if (ItemContext.INSTITUTIONAL_PAGE.getId().equalsIgnoreCase(itemContext)) {
            eventType = this.messagingProperties.getFavouriteItemFolloweeInstitutionalPageCreatedEventType();
        } else if ("event".equalsIgnoreCase(itemContext)) {
            eventType = this.messagingProperties.getFavouriteItemFolloweeEventCreatedEventType();
        } else if ("news".equalsIgnoreCase(itemContext)) {
            eventType = this.messagingProperties.getFavouriteItemFolloweeNewsCreatedEventType();
        }
        if (StringUtils.isNotBlank((CharSequence)eventType)) {
            this.publish(resourceByFollowee.getId(), (Object)resourceByFollowee, eventType);
        } else {
            log.info("Item context not supported to publish the resource created by followee event - {}", (Object)itemContext);
        }
    }

    private <T> void publish(@NonNull String resourceId, @NonNull T resource, @NonNull String eventType) {
        try {
            Map<String, T> messageMap = Map.of(resourceId, resource);
            Map<String, String> filterProperties = Map.of("service", "favourite-item");
            log.debug("Sending event message, messageMap:{}, eventType: {}, source: {}, filterProperties: {}", new Object[]{messageMap, eventType, this.messagingProperties.getSource(), filterProperties});
            this.messageProducer.publishEvent(messageMap, eventType, this.messagingProperties.getSource(), filterProperties);
            log.info("Successfully published event message for resource with id: {}", (Object)resourceId);
        }
        catch (Exception e) {
            String errorMessage = "Error occurred while sending event message: %s".formatted(e.getMessage());
            throw new WP2MessagingException(errorMessage, (Throwable)e);
        }
    }
}

