/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.favourite.user.bs.service.impl;

import com.finconsgroup.itserr.marketplace.core.web.bean.FilterProperties;
import com.finconsgroup.itserr.marketplace.core.web.dto.OutputPageDto;
import com.finconsgroup.itserr.marketplace.core.web.enums.SortDirection;
import com.finconsgroup.itserr.marketplace.core.web.exception.WP2ResourceNotFoundException;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.bean.DetailRequest;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.client.SearchDmClient;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.config.FavouriteUserBsProperties;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.dto.InputFindFavouriteDetailDto;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.dto.search.OutputCatalogFavouriteDto;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.enums.ItemContext;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.service.FavouriteUserItemDetailProviderRegistry;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.service.impl.AbstractFavouriteUserItemDetailProvider;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FavouriteUserItemCatalogDetailProvider
extends AbstractFavouriteUserItemDetailProvider<OutputCatalogFavouriteDto> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FavouriteUserItemCatalogDetailProvider.class);
    private static final String FILTER_KEY_TYPE = "type";
    private static final String FILTER_KEY_STATUS = "status";
    private static final Set<String> SUPPORTED_FILTER_KEYS = Set.of("type", "status");
    private final SearchDmClient searchDmClient;

    public FavouriteUserItemCatalogDetailProvider(@NonNull FavouriteUserItemDetailProviderRegistry favouriteUserItemDetailProviderRegistry, @NonNull SearchDmClient searchDmClient, @NonNull FavouriteUserBsProperties favouriteUserBsProperties) {
        super(favouriteUserItemDetailProviderRegistry, favouriteUserBsProperties, ItemContext.CATALOG);
        Objects.requireNonNull(searchDmClient, "searchDmClient must not be null");
        this.searchDmClient = searchDmClient;
    }

    @NonNull
    public OutputCatalogFavouriteDto getDetailById(@NonNull String itemId) {
        Objects.requireNonNull(itemId, "itemId must not be null");
        InputFindFavouriteDetailDto inputFindFavouriteDetailDto = InputFindFavouriteDetailDto.builder().ids(List.of(itemId)).build();
        OutputPageDto outputCatalogFavouritePageDto = this.searchDmClient.getFavourite(inputFindFavouriteDetailDto, null, 0, 1, "id", SortDirection.ASC);
        if (CollectionUtils.isEmpty((Collection)outputCatalogFavouritePageDto.getContent())) {
            throw new WP2ResourceNotFoundException("Favourite catalog item not found");
        }
        return (OutputCatalogFavouriteDto)outputCatalogFavouritePageDto.getContent().getFirst();
    }

    @NonNull
    public OutputPageDto<OutputCatalogFavouriteDto> getDetails(@NonNull DetailRequest request) {
        if (request.getItemIds() == null || request.getItemIds().isEmpty()) {
            return OutputPageDto.emptyWithPageSize((int)request.getPageRequestDto().getPageSize());
        }
        StringBuilder filters = new StringBuilder();
        if (request.getFilters() != null) {
            FilterProperties filterProperties = this.getFilterProperties();
            for (DetailRequest.Filter filter : request.getFilters()) {
                filters.append(filter.getKey()).append(filterProperties.keyValueSeparator()).append(filter.getValue());
            }
        }
        return this.searchDmClient.getFavourite(InputFindFavouriteDetailDto.builder().ids(request.getItemIds()).build(), filters.toString(), request.getPageRequestDto().getPageNumber(), request.getPageRequestDto().getPageSize(), request.getPageRequestDto().getSort(), request.getPageRequestDto().getDirection());
    }

    @NonNull
    public Set<String> getSupportedFilterKeys() {
        return SUPPORTED_FILTER_KEYS;
    }
}

