/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.favourite.user.dm.api;

import com.finconsgroup.itserr.marketplace.core.web.validation.annotation.ValidPutIdParameters;
import com.finconsgroup.itserr.marketplace.favourite.user.dm.dto.InputCreateFavouriteUserItemDto;
import com.finconsgroup.itserr.marketplace.favourite.user.dm.dto.InputPatchFavouriteUserItemDto;
import com.finconsgroup.itserr.marketplace.favourite.user.dm.dto.OutputFavouriteUserItemDto;
import com.finconsgroup.itserr.marketplace.favourite.user.dm.dto.OutputFavouriteUserItemSubscriberDto;
import com.finconsgroup.itserr.marketplace.favourite.user.dm.enums.ItemContext;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.Positive;
import jakarta.validation.constraints.PositiveOrZero;
import jakarta.validation.constraints.Size;
import java.util.List;
import java.util.UUID;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Sort;
import org.springframework.http.HttpStatus;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;

@Tag(name="Favourite User Items", description="Operations related to favourite user items")
@SecurityRequirement(name="BearerAuth")
@ApiResponses(value={@ApiResponse(responseCode="401", ref="Unauthorized"), @ApiResponse(responseCode="500", ref="InternalServerError")})
@Validated
public interface FavouriteUserItemApi {
    @Operation(summary="Create new favourite user item for logged in user", description="Create a new favourite user item for the given context based onthe provided dto. It also performs validations and returns errors in case of validation failures")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="OK"), @ApiResponse(responseCode="400", ref="BadRequest"), @ApiResponse(responseCode="409", ref="Conflict")})
    @ResponseStatus(value=HttpStatus.CREATED)
    @PostMapping(value={"/favourite-user/items"}, produces={"application/json"}, consumes={"application/json"})
    public OutputFavouriteUserItemDto create(@Valid @RequestBody InputCreateFavouriteUserItemDto var1);

    @Operation(summary="Fetches favourite user item for the provided id for logged in user", description="Fetches a favourite user item using the provided id.It returns not found response in case if the id does not exist")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", ref="NotFound")})
    @GetMapping(value={"/favourite-user/items/{favouriteUserItemId}"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public OutputFavouriteUserItemDto get(@PathVariable(value="favouriteUserItemId") UUID var1);

    @Operation(summary="Deletes favourite user item for the provided id for logged in user", description="Deletes a favourite user item using the provided id.It returns not found response in case if the id does not exist")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="404", ref="NotFound")})
    @DeleteMapping(value={"/favourite-user/items/{favouriteUserItemId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void delete(@PathVariable(value="favouriteUserItemId") UUID var1);

    @Operation(summary="Updates an existing favourite user item for logged in user", description="Updates only the provided fields of favourite user item based on the provided dto. It also performs validations and returns errors in case of validation failures")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="400", ref="BadRequest"), @ApiResponse(responseCode="404", ref="NotFound")})
    @ResponseStatus(value=HttpStatus.OK)
    @PatchMapping(value={"/favourite-user/items/{favouriteUserItemId}"}, produces={"application/json"}, consumes={"application/json"})
    @ValidPutIdParameters(pathIdParam="favouriteUserItemId")
    public OutputFavouriteUserItemDto patch(@PathVariable(value="favouriteUserItemId") UUID var1, @Valid @RequestBody InputPatchFavouriteUserItemDto var2);

    @Operation(summary="Retrieve all favourite user items matching the provided context for logged in user", parameters={@Parameter(name="context", description="The context to search favourite user items for"), @Parameter(name="subContext", description="The sub context to search favourite user items for"), @Parameter(name="pageNumber", description="The page index, starting from 0"), @Parameter(name="pageSize", description="The number of items per page"), @Parameter(name="sort", description="The field by which to sort the results"), @Parameter(name="direction", description="The sorting direction: ASC or DESC")}, responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="400", ref="BadRequest")})
    @ResponseStatus(value=HttpStatus.OK)
    @GetMapping(value={"/favourite-user/items"}, produces={"application/json"})
    public Page<OutputFavouriteUserItemDto> findByContext(@RequestParam(name="context") ItemContext var1, @RequestParam(name="subContext", required=false) String var2, @RequestParam(name="pageNumber", defaultValue="0", required=false) @PositiveOrZero int var3, @RequestParam(name="pageSize", defaultValue="10", required=false) @Positive int var4, @RequestParam(name="sort", defaultValue="id", required=false) String var5, @RequestParam(name="direction", defaultValue="ASC", required=false) Sort.Direction var6);

    @Operation(summary="Retrieve all favourite user items matching the provided context for logged in user", parameters={@Parameter(name="context", description="The context to search favourite user items for"), @Parameter(name="subContext", description="The sub context to search favourite user items for"), @Parameter(name="itemIds", description="The items ids separated by a separator"), @Parameter(name="itemIdSeparator", description="The item id separator, default if comma i.e ','")}, responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="400", ref="BadRequest")})
    @ResponseStatus(value=HttpStatus.OK)
    @GetMapping(value={"/favourite-user/items-by-item-ids"}, produces={"application/json"})
    public List<OutputFavouriteUserItemDto> findByContextAndItemIds(@RequestParam(name="context") ItemContext var1, @RequestParam(name="subContext", required=false) String var2, @NotBlank @RequestParam(name="itemIds") String var3, @Size(min=1) @RequestParam(name="itemIdSeparator", required=false, defaultValue=",") @Size(min=1) String var4);

    @Operation(summary="Retrieves a paginated list of the subscribers that have followed the item", parameters={@Parameter(name="context", description="The context to search favourite user items for"), @Parameter(name="subContext", description="The sub context to search favourite user items for"), @Parameter(name="itemId", description="The item id to search for"), @Parameter(name="pageNumber", description="The page index, starting from 0"), @Parameter(name="pageSize", description="The number of items per page"), @Parameter(name="sort", description="The field by which to sort the results"), @Parameter(name="direction", description="The sorting direction: ASC or DESC")}, responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="400", ref="BadRequest")})
    @ResponseStatus(value=HttpStatus.OK)
    @GetMapping(value={"/favourite-user/items/subscribers"}, produces={"application/json"})
    public Page<OutputFavouriteUserItemSubscriberDto> findSubscribers(@RequestParam(name="context") ItemContext var1, @RequestParam(name="subContext", required=false) String var2, @NotBlank @RequestParam(name="itemId") String var3, @RequestParam(name="pageNumber", defaultValue="0", required=false) @PositiveOrZero int var4, @RequestParam(name="pageSize", defaultValue="10", required=false) @Positive int var5, @RequestParam(name="sort", defaultValue="id", required=false) String var6, @RequestParam(name="direction", defaultValue="ASC", required=false) Sort.Direction var7);

    @Operation(summary="Deletes related favourite user items for all users.", parameters={@Parameter(name="context", description="The context to search favourite user items for"), @Parameter(name="subContext", description="The sub context to search favourite user items for"), @Parameter(name="itemId", description="The item id to search for")}, responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="400", ref="BadRequest")}, hidden=true)
    @ResponseStatus(value=HttpStatus.OK)
    @DeleteMapping(value={"/favourite-user/items-by-item-id"}, produces={"application/json"})
    public List<OutputFavouriteUserItemDto> deleteByContextAndItemId(@RequestParam(name="context") ItemContext var1, @RequestParam(name="subContext", required=false) String var2, @NotBlank @RequestParam(name="itemId") String var3);
}

