package com.finconsgroup.itserr.marketplace.institutional_page.bs.repository;

import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.bs.FileUploadWorkspaceBsClient;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.bs.WorkspaceBsClient;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.bs.dto.CreateDocumentWorkspaceBsDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.bs.dto.CreateFolderWorkspaceBsDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.bs.dto.DocumentPublicLinkWorkspaceBsDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.bs.dto.DocumentWorkspaceBsDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.bs.dto.OutputItemDtoWorkspaceBsDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.bs.dto.ShareFolderWorkspaceBsDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.OutputUserProfileDto;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

import java.io.InputStream;
import java.net.URI;
import java.time.Instant;
import java.util.List;
import java.util.UUID;

@Component
@RequiredArgsConstructor
public class WorkspaceRepository {
    private static final String WRITE_ALL_ROLE = "WRITE_ALL";

    private final WorkspaceBsClient workspaceBsClient;
    private final FileUploadWorkspaceBsClient fileUploadWorkspaceBsClient;

    public UUID createInstitutionalPageFolder(String institutionalPageName) {
        // Getting the workspace id and creating inside it, the institutional page folder
        UUID workspaceId = workspaceBsClient.getWorkspace().getId();
        String institutionalPageFolderIdStr = workspaceBsClient.createFolder(workspaceId, new CreateFolderWorkspaceBsDto(
                institutionalPageName + Instant.now(),
                "",
                true
        ));
        return UUID.fromString(institutionalPageFolderIdStr);
    }

    public void shareInstitutionalPageFolderToUsers(UUID institutionalPageFolderId, List<OutputUserProfileDto> userProfiles) {
        if (userProfiles.isEmpty()) return;

        workspaceBsClient.shareFolder(
                institutionalPageFolderId,
                new ShareFolderWorkspaceBsDto(
                        userProfiles.stream().map(OutputUserProfileDto::getPreferredUsername).toList(),
                        WRITE_ALL_ROLE
                )
        );
    }

    public UUID unshareInstitutionalPageFolderFromUsers(UUID institutionalPageFolderId, List<OutputUserProfileDto> userProfiles) {
        if (userProfiles.isEmpty())
            return null;

        return UUID.fromString(workspaceBsClient.unshareFolder(
                institutionalPageFolderId,
                userProfiles.stream().map(OutputUserProfileDto::getPreferredUsername).toList()
        ));
    }

    public UUID unshareInstitutionalPageFolderFromUsers(UUID institutionalPageFolderId, String preferredUsername) {
        if (preferredUsername == null || preferredUsername.isEmpty()) return null;

        return UUID.fromString(workspaceBsClient.unshareFolder(
                institutionalPageFolderId,
                List.of(preferredUsername)
        ));
    }

    public URI uploadInstitutionalPageImage(UUID institutionalPageFolderId, InputStream imageContent, String imageName, String imageDescription) {
        // Create an empty document
        CreateDocumentWorkspaceBsDto createDocumentDto = new CreateDocumentWorkspaceBsDto(
                imageName,
                imageDescription
        );
        DocumentWorkspaceBsDto emptyDocument = workspaceBsClient.createEmptyDocument(institutionalPageFolderId, createDocumentDto);
        
        // Upload image content to the empty document
        fileUploadWorkspaceBsClient.createFile(imageContent, emptyDocument.getId(), imageName);
        
        // Get the public link of the image
        DocumentPublicLinkWorkspaceBsDto publicLink = workspaceBsClient.getDocumentPublicLink(emptyDocument.getId());
        
        return publicLink.getPublicLink();
    }

    public List<OutputItemDtoWorkspaceBsDto> getWorkspaceChildrenByFolderId(UUID folderId, Integer pageNo, Integer pageSize) {
        return workspaceBsClient.getWorkspaceChildrenByFolderId(folderId.toString(), pageNo, pageSize);
    }

}
