/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.institutional_page.bs.messaging.impl;

import com.finconsgroup.itserr.marketplace.institutional_page.bs.config.properties.InstitutionalPageBsConfigurationProperties;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.messaging.NotificationProducer;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.messaging.data.InstitutionalPageCreatedNotificationData;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.messaging.data.InstitutionalPageDeletedNotificationData;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.messaging.data.InstitutionalPagePublicationRequestNotificationData;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.messaging.data.InstitutionalPageStatusChangeNotificationData;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.messaging.data.InstitutionalPageUpdatedNotificationData;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.messaging.data.JoinRequestNotificationData;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.messaging.data.JoinRequestStatusChangeNotificationData;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.messaging.data.MemberInvitationNotificationData;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.messaging.data.MemberInvitationStatusChangeNotificationData;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.messaging.data.MembershipChangeNotificationData;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.messaging.data.MembershipRemovalNotificationData;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.messaging.data.ParagraphCreatedNotificationData;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.messaging.data.ParagraphDeletedNotificationData;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.messaging.data.ParagraphUpdatedNotificationData;
import com.finconsgroup.itserr.messaging.dto.MessagingEventDto;
import com.finconsgroup.itserr.messaging.exception.WP2MessagingException;
import com.finconsgroup.itserr.messaging.producer.MessageProducer;
import com.finconsgroup.itserr.messaging.producer.ProducerRegistry;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(name={"messaging.enabled"}, havingValue="true")
public class DefaultNotificationProducer
implements NotificationProducer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultNotificationProducer.class);
    private final MessageProducer messageProducer;
    private final InstitutionalPageBsConfigurationProperties.Messaging messagingProperties;

    public DefaultNotificationProducer(InstitutionalPageBsConfigurationProperties institutionalPageBsConfigurationProperties, ProducerRegistry producerRegistry) {
        this.messagingProperties = institutionalPageBsConfigurationProperties.getMessaging();
        this.messageProducer = producerRegistry.getMessageProducer(this.messagingProperties.getNotificationProducerName());
    }

    public void publishInstitutionalPageCreatedNotification(MessagingEventDto<InstitutionalPageCreatedNotificationData> message) {
        this.publish(message, this.messagingProperties.getCreatedNotificationType());
    }

    public void publishInstitutionalPageUpdatedNotification(MessagingEventDto<InstitutionalPageUpdatedNotificationData> message) {
        this.publish(message, this.messagingProperties.getUpdatedNotificationType());
    }

    public void publishInstitutionalPageDeletedNotification(MessagingEventDto<InstitutionalPageDeletedNotificationData> message) {
        this.publish(message, this.messagingProperties.getDeletedNotificationType());
    }

    public void publishInstitutionalPageStatusChangeNotification(MessagingEventDto<InstitutionalPageStatusChangeNotificationData> message) {
        this.publish(message, this.messagingProperties.getStatusChangeNotificationType());
    }

    public void publishInstitutionalPagePublicationRequestNotification(MessagingEventDto<InstitutionalPagePublicationRequestNotificationData> message) {
        this.publish(message, this.messagingProperties.getPublicationRequestNotificationType());
    }

    public void publishJoinRequestNotification(MessagingEventDto<JoinRequestNotificationData> message) {
        this.publish(message, this.messagingProperties.getJoinRequestCreatedNotificationType());
    }

    public void publishJoinRequestDeletedNotification(MessagingEventDto<JoinRequestNotificationData> message) {
        this.publish(message, this.messagingProperties.getJoinRequestDeletedNotificationType());
    }

    public void publishJoinRequestStatusChangeNotification(MessagingEventDto<JoinRequestStatusChangeNotificationData> message) {
        this.publish(message, this.messagingProperties.getJoinRequestStatusChangeNotificationType());
    }

    public void publishMemberInvitationNotification(MessagingEventDto<MemberInvitationNotificationData> message) {
        this.publish(message, this.messagingProperties.getMemberInvitationCreatedNotificationType());
    }

    public void publishMemberInvitationDeletedNotification(MessagingEventDto<MemberInvitationNotificationData> message) {
        this.publish(message, this.messagingProperties.getMemberInvitationDeletedNotificationType());
    }

    public void publishMemberInvitationStatusChangeNotification(MessagingEventDto<MemberInvitationStatusChangeNotificationData> message) {
        this.publish(message, this.messagingProperties.getMemberInvitationStatusChangeNotificationType());
    }

    public void publishMembershipChangeNotification(MessagingEventDto<MembershipChangeNotificationData> message) {
        this.publish(message, this.messagingProperties.getMembershipChangeNotificationType());
    }

    public void publishMembershipRemovalNotification(MessagingEventDto<MembershipRemovalNotificationData> message) {
        this.publish(message, this.messagingProperties.getMembershipRemovalNotificationType());
    }

    public void publishParagraphCreatedNotification(MessagingEventDto<ParagraphCreatedNotificationData> message) {
        this.publish(message, this.messagingProperties.getParagraphCreatedNotificationType());
    }

    public void publishParagraphUpdatedNotification(MessagingEventDto<ParagraphUpdatedNotificationData> message) {
        this.publish(message, this.messagingProperties.getParagraphUpdatedNotificationType());
    }

    public void publishParagraphDeletedNotification(MessagingEventDto<ParagraphDeletedNotificationData> message) {
        this.publish(message, this.messagingProperties.getParagraphDeletedNotificationType());
    }

    private void publish(@NonNull MessagingEventDto<?> message, @NonNull String eventType) {
        try {
            Map<String, MessagingEventDto<?>> messageMap = Map.of(message.getId(), message);
            Map<String, String> filterProperties = Map.of("service", "institutional-page");
            log.debug("Sending notification message, messageMap: %s, eventType: %s, source: %s, filterProperties: %s".formatted(messageMap, eventType, this.messagingProperties.getSource(), filterProperties));
            this.messageProducer.publishEvent(messageMap, eventType, this.messagingProperties.getSource(), filterProperties);
            log.info("Successfully published notification event message for object with id: %s".formatted(message.getId()));
        }
        catch (Exception e) {
            String errorMessage = "Error occurred while sending notification event message: %s".formatted(e.getMessage());
            throw new WP2MessagingException(errorMessage);
        }
    }
}

