/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.institutional_page.bs.mapper;

import com.finconsgroup.itserr.marketplace.core.web.dto.OutputPageDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm.dto.InstitutionalPageForMembersInHierarchyIPDmDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm.dto.InviteMembersIPDmDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm.dto.MembersInHierarchyIPDmDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm.dto.PatchIPInvitationRequestIPDmDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm.dto.PatchIPJoinRequestIPDmDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm.dto.PatchMembershipIPDmDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm.dto.PendingMemberRequestIPDmDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm.dto.PendingMemberRequestsIPDmDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm.dto.RemoveMembershipIPDmDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm.dto.SubmitJoinRequestIPDmDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.InputInviteMembersDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.InputPatchIPInvitationRequestDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.InputPatchIPJoinRequestDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.InputPatchMembershipDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.InputRemoveMembershipDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.InputSubmitJoinRequestDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.OutputInstitutionalPageForMembersInHierarchyDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.OutputMembersInHierarchyDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.OutputPendingMemberRequestDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.OutputPendingMemberRequestsDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.OutputUserProfileDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.mapper.InstitutionalPageMapper;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.mapper.MemberPartialMapper;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.repository.UserProfileRepository;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.springframework.stereotype.Component;

@Component
public class MemberMapper {
    private final InstitutionalPageMapper institutionalPageMapper;
    private final MemberPartialMapper partialMapper;
    private final UserProfileRepository userProfileRepository;

    public InviteMembersIPDmDto toInviteMembersIPDmDto(InputInviteMembersDto dto) {
        return this.partialMapper.toInviteMembersIPDmDto(dto);
    }

    public SubmitJoinRequestIPDmDto toSubmitJoinRequestIPDmDto(InputSubmitJoinRequestDto dto) {
        return this.partialMapper.toSubmitJoinRequestIPDmDto(dto);
    }

    public PatchIPInvitationRequestIPDmDto toPatchIPInvitationRequestIPDmDto(InputPatchIPInvitationRequestDto dto) {
        return this.partialMapper.toPatchIPInvitationRequestIPDmDto(dto);
    }

    public PatchIPJoinRequestIPDmDto toPatchIPJoinRequestIPDmDto(InputPatchIPJoinRequestDto dto) {
        return this.partialMapper.toPatchIPJoinRequestIPDmDto(dto);
    }

    public PatchMembershipIPDmDto toPatchMembershipIPDmDto(InputPatchMembershipDto dto) {
        return this.partialMapper.toPatchMembershipIPDmDto(dto);
    }

    public RemoveMembershipIPDmDto toRemoveMembershipIPDmDto(InputRemoveMembershipDto dto) {
        return this.partialMapper.toRemoveMembershipIPDmDto(dto);
    }

    public OutputPendingMemberRequestsDto toOutputPendingMemberRequestsDto(PendingMemberRequestsIPDmDto dto) {
        List<OutputPendingMemberRequestDto> joinRequests = dto.getJoinRequests().stream().map(arg_0 -> this.toOutputPendingMemberRequestDto(arg_0)).toList();
        List<OutputPendingMemberRequestDto> invitations = dto.getInvitations().stream().map(arg_0 -> this.toOutputPendingMemberRequestDto(arg_0)).toList();
        return OutputPendingMemberRequestsDto.builder().joinRequests(joinRequests).invitations(invitations).build();
    }

    public OutputPendingMemberRequestDto toOutputPendingMemberRequestDto(PendingMemberRequestIPDmDto dto) {
        OutputPendingMemberRequestDto outputPendingMemberRequestDto = this.partialMapper.toOutputPendingMemberRequestDto(dto);
        UUID userId = dto.getUserId();
        OutputUserProfileDto userProfileDto = (OutputUserProfileDto)this.userProfileRepository.getMemberProfilesOrThrow(List.of(userId)).getFirst();
        outputPendingMemberRequestDto.setUser(userProfileDto);
        outputPendingMemberRequestDto.setInstitutionalPage(this.institutionalPageMapper.toOutputInstitutionalPageDto(dto.getInstitutionalPage(), true));
        return outputPendingMemberRequestDto;
    }

    public OutputPageDto<OutputMembersInHierarchyDto> toOutputMembersInHierarchyDto(OutputPageDto<MembersInHierarchyIPDmDto> dto) {
        ArrayList outputMembersInHierarchyDtoList = new ArrayList();
        dto.getContent().forEach(membersInHierarchyIPDmDto -> {
            OutputMembersInHierarchyDto outputMembersInHierarchyDto = this.partialMapper.toOutputMembersInHierarchyDto(membersInHierarchyIPDmDto);
            UUID userId = membersInHierarchyIPDmDto.getUserId();
            OutputUserProfileDto userProfileDto = (OutputUserProfileDto)this.userProfileRepository.getMemberProfilesOrThrow(List.of(userId)).getFirst();
            outputMembersInHierarchyDto.setUser(userProfileDto);
            outputMembersInHierarchyDto.setInstitutionalPages(this.toOutputInstitutionalPageForMembersInHierarchyDto(membersInHierarchyIPDmDto.getInstitutionalPages()));
            outputMembersInHierarchyDto.setRootInstitutionalPage(this.institutionalPageMapper.toOutputInstitutionalPageDto(membersInHierarchyIPDmDto.getRootInstitutionalPage(), true));
            outputMembersInHierarchyDtoList.add(outputMembersInHierarchyDto);
        });
        return OutputPageDto.builder().page(dto.getPage()).content(outputMembersInHierarchyDtoList).build();
    }

    public List<OutputInstitutionalPageForMembersInHierarchyDto> toOutputInstitutionalPageForMembersInHierarchyDto(List<InstitutionalPageForMembersInHierarchyIPDmDto> dto) {
        ArrayList<OutputInstitutionalPageForMembersInHierarchyDto> outputInstitutionalPageForMembersInHierarchyDtoList = new ArrayList<OutputInstitutionalPageForMembersInHierarchyDto>();
        dto.forEach(institutionalPageForMembersInHierarchyIPDmDto -> {
            OutputInstitutionalPageForMembersInHierarchyDto outputInstitutionalPageForMembersInHierarchyDto = this.partialMapper.toOutputInstitutionalPageForMembersInHierarchyDto(institutionalPageForMembersInHierarchyIPDmDto);
            outputInstitutionalPageForMembersInHierarchyDto.setInstitutionalPage(this.institutionalPageMapper.toOutputInstitutionalPageDto(institutionalPageForMembersInHierarchyIPDmDto.getInstitutionalPage(), true));
            outputInstitutionalPageForMembersInHierarchyDtoList.add(outputInstitutionalPageForMembersInHierarchyDto);
        });
        return outputInstitutionalPageForMembersInHierarchyDtoList;
    }

    @Generated
    public MemberMapper(InstitutionalPageMapper institutionalPageMapper, MemberPartialMapper partialMapper, UserProfileRepository userProfileRepository) {
        this.institutionalPageMapper = institutionalPageMapper;
        this.partialMapper = partialMapper;
        this.userProfileRepository = userProfileRepository;
    }
}

