/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.institutional_page.bs.api;

import com.finconsgroup.itserr.marketplace.core.web.dto.OutputPageDto;
import com.finconsgroup.itserr.marketplace.core.web.enums.SortDirection;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.InputCreateInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.InputSearchForMemberInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.InputUpdateInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.ModerationStatus;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.OutputInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.OutputRequestUpdateDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.OutputWorkspaceItemDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.validation.ValidAssociationToLoad;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Encoding;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Positive;
import jakarta.validation.constraints.PositiveOrZero;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.multipart.MultipartFile;

@Tag(name="Institutional pages", description="Operations related to the institutional pages")
@SecurityRequirement(name="BearerAuth")
public interface InstitutionalPageApi {
    @Operation(summary="Get all institutional pages")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    @GetMapping(path={"/institutional-page/institutional-pages"}, produces={"application/json"})
    public ResponseEntity<OutputPageDto<OutputInstitutionalPageDto>> getAllInstitutionalPages(@RequestParam(name="moderationStatus") ModerationStatus var1, @RequestParam(name="includePublishedAndNotMember", defaultValue="false", required=false) boolean var2, @RequestParam(name="associationsToLoad", defaultValue="all", required=false) Set<@ValidAssociationToLoad String> var3, @RequestParam(name="pageNumber", defaultValue="0", required=false) @PositiveOrZero int var4, @RequestParam(name="pageSize", defaultValue="10", required=false) @Positive int var5, @RequestParam(name="sort", defaultValue="name", required=false) String var6, @RequestParam(name="direction", defaultValue="ASC", required=false) SortDirection var7);

    @Operation(summary="Get institutional page by id, only if the user is a member")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    @GetMapping(path={"/institutional-page/institutional-pages/{institutionalPageId}"}, produces={"application/json"})
    public ResponseEntity<OutputInstitutionalPageDto> getInstitutionalPageById(@PathVariable UUID var1, @RequestParam(name="moderationStatus", required=false) ModerationStatus var2, @RequestParam(name="includePublishedAndNotMember", defaultValue="false", required=false) boolean var3);

    @Operation(summary="Create an institutional page", requestBody=@io.swagger.v3.oas.annotations.parameters.RequestBody(required=true, content={@Content(mediaType="multipart/form-data", encoding={@Encoding(name="institutionalPageDto", contentType="application/json"), @Encoding(name="imageFile", contentType="image/*")})}))
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Created")})
    @PostMapping(value={"/institutional-page/institutional-pages"}, consumes={"multipart/form-data"}, produces={"application/json"})
    public ResponseEntity<OutputInstitutionalPageDto> createInstitutionalPage(@Valid @RequestPart(value="institutionalPageDto") InputCreateInstitutionalPageDto var1, @RequestPart(value="imageFile", required=false) MultipartFile var2);

    @Operation(summary="Update an institutional page by id, only if the user is a member", requestBody=@io.swagger.v3.oas.annotations.parameters.RequestBody(required=true, content={@Content(mediaType="multipart/form-data", encoding={@Encoding(name="institutionalPageDto", contentType="application/json"), @Encoding(name="imageFile", contentType="image/*")})}))
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    @PutMapping(value={"/institutional-page/institutional-pages/{institutionalPageId}"}, consumes={"multipart/form-data"}, produces={"application/json"})
    public ResponseEntity<OutputInstitutionalPageDto> updateInstitutionalPage(@PathVariable UUID var1, @Valid @RequestPart(value="institutionalPageDto") InputUpdateInstitutionalPageDto var2, @RequestPart(value="imageFile", required=false) MultipartFile var3);

    @Operation(summary="Delete an institutional page by id, only if the user is a member")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="No content")})
    @DeleteMapping(value={"/institutional-page/institutional-pages/{institutionalPageId}"})
    public ResponseEntity<Void> deleteInstitutionalPage(@PathVariable UUID var1);

    @Operation(summary="Find all InstitutionalPages the user is contributing to,matching the search criteria", responses={@ApiResponse(responseCode="200", description="OK")})
    @PostMapping(value={"/institutional-page/institutional-pages/search"}, consumes={"application/json"}, produces={"application/json"})
    public ResponseEntity<OutputPageDto<OutputInstitutionalPageDto>> search(@RequestParam(name="moderationStatus") ModerationStatus var1, @Valid @RequestBody InputSearchForMemberInstitutionalPageDto var2, @RequestParam(name="associationsToLoad", defaultValue="all", required=false) Set<@ValidAssociationToLoad String> var3, @RequestParam(name="pageNumber", defaultValue="0", required=false) @PositiveOrZero int var4, @RequestParam(name="pageSize", defaultValue="10", required=false) @Positive int var5, @RequestParam(name="sort", defaultValue="name", required=false) String var6, @RequestParam(name="direction", defaultValue="ASC", required=false) SortDirection var7);

    @Operation(summary="Retrieves a paginated list of all InstitutionalPages the user is contributing to, corresponding to the hierarchy associated to the rootInstitutionalPageId", responses={@ApiResponse(responseCode="200", description="OK")})
    @GetMapping(value={"/institutional-page/institutional-pages/{institutionalPageId}/hierarchy"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public ResponseEntity<OutputPageDto<OutputInstitutionalPageDto>> findInstitutionalPagesHierarchyByRootId(@PathVariable(value="institutionalPageId") UUID var1, @RequestParam(name="associationsToLoad", defaultValue="all", required=false) Set<@ValidAssociationToLoad String> var2, @RequestParam(name="pageNumber", defaultValue="0", required=false) @PositiveOrZero int var3, @RequestParam(name="pageSize", defaultValue="10", required=false) @Positive int var4, @RequestParam(name="sort", defaultValue="name", required=false) String var5, @RequestParam(name="direction", defaultValue="ASC", required=false) SortDirection var6);

    @Operation(summary="Retrieve folder content related to institutional page")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    @GetMapping(path={"/institutional-page/institutional-pages/{institutionalPageId}/folder-content"}, produces={"application/json"})
    public ResponseEntity<List<OutputWorkspaceItemDto>> retrieveFolderContent(@PathVariable UUID var1, @RequestParam(name="pageNumber", defaultValue="0", required=false) @PositiveOrZero int var2, @RequestParam(name="pageSize", defaultValue="10", required=false) @Positive int var3);

    @Operation(summary="Request moderation for a specific InstitutionalPage by id, only if the user is a member", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Not Found")})
    @PutMapping(value={"/institutional-page/institutional-pages/{institutionalPageId}/request-moderation"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public OutputInstitutionalPageDto requestModerationInstitutionalPage(@PathVariable(value="institutionalPageId") UUID var1);

    @Operation(summary="Request publication for a specific InstitutionalPage by id, only if the user is a member", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Not Found")})
    @PutMapping(value={"/institutional-page/institutional-pages/{institutionalPageId}/request-publication"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public OutputInstitutionalPageDto requestPublicationInstitutionalPage(@PathVariable(value="institutionalPageId") UUID var1);

    @Operation(summary="Request update for a specific InstitutionalPage by id, only if the user is a member", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Not Found")})
    @PutMapping(value={"/institutional-page/institutional-pages/{institutionalPageId}/request-update"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public ResponseEntity<OutputRequestUpdateDto> requestUpdateInstitutionalPageById(@PathVariable(value="institutionalPageId") UUID var1);

    @Operation(summary="Release lock-for-update of a specific InstitutionalPage by id, only if the user is a member", responses={@ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="404", description="Not Found")})
    @PutMapping(value={"/institutional-page/institutional-pages/{institutionalPageId}/cancel-update"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public ResponseEntity<Void> cancelUpdateInstitutionalPageById(@PathVariable(value="institutionalPageId") UUID var1);
}

