/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.institutional_page.bs.repository;

import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.bs.FileUploadWorkspaceBsClient;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.bs.WorkspaceBsClient;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.bs.dto.CreateDocumentWorkspaceBsDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.bs.dto.CreateFolderWorkspaceBsDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.bs.dto.DocumentPublicLinkWorkspaceBsDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.bs.dto.DocumentWorkspaceBsDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.bs.dto.OutputItemDtoWorkspaceBsDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.bs.dto.ShareFolderWorkspaceBsDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.OutputUserProfileDto;
import java.io.InputStream;
import java.net.URI;
import java.time.Instant;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.springframework.stereotype.Component;

@Component
public class WorkspaceRepository {
    private static final String WRITE_ALL_ROLE = "WRITE_ALL";
    private final WorkspaceBsClient workspaceBsClient;
    private final FileUploadWorkspaceBsClient fileUploadWorkspaceBsClient;

    public UUID createInstitutionalPageFolder(String institutionalPageName) {
        UUID workspaceId = this.workspaceBsClient.getWorkspace().getId();
        String institutionalPageFolderIdStr = this.workspaceBsClient.createFolder(workspaceId, new CreateFolderWorkspaceBsDto(institutionalPageName + String.valueOf(Instant.now()), "", true));
        return UUID.fromString(institutionalPageFolderIdStr);
    }

    public void shareInstitutionalPageFolderToUsers(UUID institutionalPageFolderId, List<OutputUserProfileDto> userProfiles) {
        if (userProfiles.isEmpty()) {
            return;
        }
        this.workspaceBsClient.shareFolder(institutionalPageFolderId, new ShareFolderWorkspaceBsDto(userProfiles.stream().map(OutputUserProfileDto::getPreferredUsername).toList(), WRITE_ALL_ROLE));
    }

    public UUID unshareInstitutionalPageFolderFromUsers(UUID institutionalPageFolderId, List<OutputUserProfileDto> userProfiles) {
        if (userProfiles.isEmpty()) {
            return null;
        }
        return UUID.fromString(this.workspaceBsClient.unshareFolder(institutionalPageFolderId, userProfiles.stream().map(OutputUserProfileDto::getPreferredUsername).toList()));
    }

    public UUID unshareInstitutionalPageFolderFromUsers(UUID institutionalPageFolderId, String preferredUsername) {
        if (preferredUsername == null || preferredUsername.isEmpty()) {
            return null;
        }
        return UUID.fromString(this.workspaceBsClient.unshareFolder(institutionalPageFolderId, List.of(preferredUsername)));
    }

    public URI uploadInstitutionalPageImage(UUID institutionalPageFolderId, InputStream imageContent, String imageName, String imageDescription) {
        CreateDocumentWorkspaceBsDto createDocumentDto = new CreateDocumentWorkspaceBsDto(imageName, imageDescription);
        DocumentWorkspaceBsDto emptyDocument = this.workspaceBsClient.createEmptyDocument(institutionalPageFolderId, createDocumentDto);
        this.fileUploadWorkspaceBsClient.createFile(imageContent, emptyDocument.getId(), imageName);
        DocumentPublicLinkWorkspaceBsDto publicLink = this.workspaceBsClient.getDocumentPublicLink(emptyDocument.getId());
        return publicLink.getPublicLink();
    }

    public List<OutputItemDtoWorkspaceBsDto> getWorkspaceChildrenByFolderId(UUID folderId, Integer pageNo, Integer pageSize) {
        return this.workspaceBsClient.getWorkspaceChildrenByFolderId(folderId.toString(), pageNo, pageSize);
    }

    @Generated
    public WorkspaceRepository(WorkspaceBsClient workspaceBsClient, FileUploadWorkspaceBsClient fileUploadWorkspaceBsClient) {
        this.workspaceBsClient = workspaceBsClient;
        this.fileUploadWorkspaceBsClient = fileUploadWorkspaceBsClient;
    }
}

