package com.finconsgroup.itserr.marketplace.institutional_page.bs.config.properties;

import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

/**
 * Configuration properties for the institutional page bs service.
 * <p>
 * These properties are mapped from the {@code institutional-page.bs} prefix in the application configuration.
 */
@Data
@Validated
@ConfigurationProperties(prefix = "institutional-page.bs")
public class InstitutionalPageBsConfigurationProperties {
    /**
     * Messaging-related configuration properties.
     */
    @NotNull
    @Valid
    private Messaging messaging;

    /**
     * Configuration for messaging
     */
    @Data
    @NoArgsConstructor
    @AllArgsConstructor
    public static class Messaging {

        /**
         * Name of the configured producer
         */
        @NotBlank
        private String institutionalPageProducerName;

        /**
         * Name of the configured event producer
         */
        @NotBlank
        private String notificationProducerName;

        /**
         * Source identifier for events, used to indicate the origin of a message.
         */
        @NotBlank
        private String source;

        /**
         * Event type string used for institutional page creation.
         */
        @NotBlank
        private String institutionalPageCreatedType;

        /**
         * Event type string used for institutional page update.
         */
        @NotBlank
        private String institutionalPageUpdatedType;

        /**
         * Event type string used for institutional page deletion.
         */
        @NotBlank
        private String institutionalPageDeletedType;

        /**
         * Event type string used for resource creation notification.
         */
        @NotBlank
        private String createdNotificationType;

        /**
         * Event type string used for resource update notification.
         */
        @NotBlank
        private String updatedNotificationType;

        /**
         * Event type string used for resource deletion notification.
         */
        @NotBlank
        private String deletedNotificationType;

        /**
         * Event type string used for resource event status change notification.
         */
        @NotBlank
        private String statusChangeNotificationType;

        /**
         * Event type string used for join request creation notification.
         */
        @NotBlank
        private String joinRequestCreatedNotificationType;

        /**
         * Event type string used for join request deletion notification.
         */
        @NotBlank
        private String joinRequestDeletedNotificationType;

        /**
         * Event type string used for join request status change notification.
         */
        @NotBlank
        private String joinRequestStatusChangeNotificationType;

        /**
         * Event type string used for member invitation creation notification.
         */
        @NotBlank
        private String memberInvitationCreatedNotificationType;

        /**
         * Event type string used for member invitation deletion notification.
         */
        @NotBlank
        private String memberInvitationDeletedNotificationType;

        /**
         * Event type string used for member invitation status change notification.
         */
        @NotBlank
        private String memberInvitationStatusChangeNotificationType;

        /**
         * Event type string used for membership change notification.
         */
        @NotBlank
        private String membershipChangeNotificationType;

        /**
         * Event type string used for membership removal notification.
         */
        @NotBlank
        private String membershipRemovalNotificationType;

        /**
         * Event type string used for paragraph creation notification.
         */
        @NotBlank
        private String paragraphCreatedNotificationType;

        /**
         * Event type string used for paragraph update notification.
         */
        @NotBlank
        private String paragraphUpdatedNotificationType;

        /**
         * Event type string used for paragraph deletion notification.
         */
        @NotBlank
        private String paragraphDeletedNotificationType;

        /**
         * Event type string used for moderation request notification.
         */
        @NotBlank
        private String moderationRequestNotificationType;

        /**
         * Event type string used for publication request notification.
         */
        @NotBlank
        private String publicationRequestNotificationType;
    }
}
