package com.finconsgroup.itserr.marketplace.institutional_page.bs.controller;

import com.finconsgroup.itserr.marketplace.core.web.dto.OutputPageDto;
import com.finconsgroup.itserr.marketplace.core.web.enums.SortDirection;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.api.InstitutionalPageApi;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.InputCreateInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.InputSearchForMemberInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.InputUpdateInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.InstitutionalPageView;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.OutputInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.OutputRequestUpdateDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.OutputWorkspaceItemDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.service.InstitutionalPageService;
import lombok.RequiredArgsConstructor;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;
import java.util.Set;
import java.util.UUID;

@RestController
@RequiredArgsConstructor
public class InstitutionalPageController implements InstitutionalPageApi {
    private final InstitutionalPageService institutionalPageService;

    @Override
    public ResponseEntity<OutputPageDto<OutputInstitutionalPageDto>> getAllInstitutionalPages(InstitutionalPageView view, boolean includePublishedAndNotMember, Set<String> associationsToLoad, int pageNumber, int pageSize, String sort, SortDirection direction) {
        OutputPageDto<OutputInstitutionalPageDto> institutionalPages = institutionalPageService.getAllInstitutionalPages(view, includePublishedAndNotMember, associationsToLoad, pageNumber, pageSize, sort, direction);
        return new ResponseEntity<>(institutionalPages, HttpStatus.OK);
    }

    @Override
    public ResponseEntity<OutputInstitutionalPageDto> getInstitutionalPageById(UUID institutionalPageId, InstitutionalPageView view, boolean includePublishedAndNotMember) {
        OutputInstitutionalPageDto institutionalPage = institutionalPageService.getInstitutionalPageById(institutionalPageId, view, includePublishedAndNotMember);
        return new ResponseEntity<>(institutionalPage, HttpStatus.OK);
    }

    @Override
    public ResponseEntity<OutputInstitutionalPageDto> createInstitutionalPage(InputCreateInstitutionalPageDto institutionalPageDto, MultipartFile imageFile) {
        OutputInstitutionalPageDto createdInstitutionalPage = institutionalPageService.createInstitutionalPage(institutionalPageDto, imageFile);
        return new ResponseEntity<>(createdInstitutionalPage, HttpStatus.CREATED);
    }

    @Override
    public ResponseEntity<OutputInstitutionalPageDto> updateInstitutionalPage(UUID institutionalPageId, InputUpdateInstitutionalPageDto institutionalPageDto, MultipartFile imageFile) {
        OutputInstitutionalPageDto updatedInstitutionalPage = institutionalPageService.updateInstitutionalPage(institutionalPageId, institutionalPageDto, imageFile);
        return new ResponseEntity<>(updatedInstitutionalPage, HttpStatus.OK);
    }

    @Override
    public ResponseEntity<Void> deleteInstitutionalPage(UUID institutionalPageId) {
        institutionalPageService.deleteInstitutionalPage(institutionalPageId);
        return new ResponseEntity<>(HttpStatus.NO_CONTENT);
    }

    @Override
    public ResponseEntity<OutputPageDto<OutputInstitutionalPageDto>> search(InstitutionalPageView view, InputSearchForMemberInstitutionalPageDto inputSearchForMemberInstitutionalPageDto, Set<String> associationsToLoad, int pageNumber, int pageSize, String sort, SortDirection direction) {
        OutputPageDto<OutputInstitutionalPageDto> institutionalPages = institutionalPageService.search(view, inputSearchForMemberInstitutionalPageDto, associationsToLoad, pageNumber, pageSize, sort, direction);
        return new ResponseEntity<>(institutionalPages, HttpStatus.OK);
    }

    @Override
    public ResponseEntity<OutputPageDto<OutputInstitutionalPageDto>> findInstitutionalPagesHierarchyByRootId(UUID rootInstitutionalPageId, Set<String> associationsToLoad, int pageNumber, int pageSize, String sort, SortDirection direction) {
        OutputPageDto<OutputInstitutionalPageDto> institutionalPages = institutionalPageService.findInstitutionalPagesHierarchyByRootId(rootInstitutionalPageId, associationsToLoad, pageNumber, pageSize, sort, direction);
        return new ResponseEntity<>(institutionalPages, HttpStatus.OK);
    }

    @Override
    public ResponseEntity<List<OutputWorkspaceItemDto>> retrieveFolderContent(UUID institutionalPageId, int pageNumber, int pageSize) {
        List<OutputWorkspaceItemDto> outputWorkspaceItemPage = institutionalPageService.retrieveFolderContent(institutionalPageId, pageNumber, pageSize);
        return new ResponseEntity<>(outputWorkspaceItemPage, HttpStatus.OK);
    }

    @Override
    public OutputInstitutionalPageDto requestModerationInstitutionalPage(final UUID institutionalPageId) {
        return institutionalPageService.requestModerationInstitutionalPage(institutionalPageId);
    }

    @Override
    public OutputInstitutionalPageDto requestPublicationInstitutionalPage(final UUID institutionalPageId) {
        return institutionalPageService.requestPublicationInstitutionalPage(institutionalPageId);
    }

    @Override
    public ResponseEntity<OutputRequestUpdateDto> requestUpdateInstitutionalPageById(UUID institutionalPageId) {
        OutputRequestUpdateDto outputRequestUpdateDto = institutionalPageService.requestUpdateInstitutionalPageById(institutionalPageId);
        return new ResponseEntity<>(outputRequestUpdateDto, HttpStatus.OK);
    }

    @Override
    public ResponseEntity<Void> cancelUpdateInstitutionalPageById(UUID institutionalPageId) {
        institutionalPageService.cancelUpdateInstitutionalPageById(institutionalPageId);
        return ResponseEntity.noContent().build();
    }
}
