package com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

import java.util.List;
import java.util.UUID;

import static com.finconsgroup.itserr.marketplace.institutionalpage.dm.util.Constants.MAX_MEDIUM_TEXT_LENGTH;
import static com.finconsgroup.itserr.marketplace.institutionalpage.dm.util.Constants.VALIDATION_ERROR_FIELD_LENGTH;
import static com.finconsgroup.itserr.marketplace.institutionalpage.dm.util.Constants.VALIDATION_ERROR_REQUIRED_FIELD;

/**
 * Input DTO to approve or reject a pending join request to an Institutional Page.
 */
@Schema(
        name = "InputPatchIPJoinRequestDto",
        description = "Input DTO to approve or reject a pending join request to an Institutional Page"
)
@Data
@Builder
@AllArgsConstructor
// TODO currently not mandatory from FE - @ValidInputDto
public class InputPatchIPJoinRequestDto {

    @Schema(
            description = "IDs of users handle pending requests",
            example = "[\"33333333-aaaa-1111-0000-000000000000\",\"33333333-aaaa-2222-0000-000000000000\"]"
    )
    @Size(min = 1, message = VALIDATION_ERROR_FIELD_LENGTH)
    private List<@NotNull(message = VALIDATION_ERROR_REQUIRED_FIELD) UUID> userIds;

    @Schema(description = "Specify whether to approve or reject the pending member request", example = "true")
    @NotNull(message = VALIDATION_ERROR_REQUIRED_FIELD)
    private Boolean approved;

    @Schema(description = "The rejection message", example = "Max number of members reached")
    @Size(max = MAX_MEDIUM_TEXT_LENGTH, message = VALIDATION_ERROR_FIELD_LENGTH)
    private String message;
}
