package com.finconsgroup.itserr.marketplace.institutionalpage.dm.mapper;

import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.OutputInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.OutputPendingMemberRequestDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.entity.MemberRequestEntity;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.enums.MemberRequestType;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;

import java.util.UUID;

@Mapper(config = MapperConfiguration.class)
public interface MemberRequestMapper {

    @Mapping(target = "institutionalPage", source = "outputInstitutionalPageDto")
    OutputPendingMemberRequestDto toOutputPendingRequestDto(
            MemberRequestEntity memberRequestEntity,
            OutputInstitutionalPageDto outputInstitutionalPageDto
    );

    @Mapping(target = "id", ignore = true) // not updatable
    @Mapping(target = "creationTime", ignore = true) // will be set manually if needed
    @Mapping(target = "updateTime", ignore = true) // will be set manually if needed
    @Mapping(target = "version", ignore = true)
    MemberRequestEntity toMemberRequestEntity(
            UUID userId,
            UUID institutionalPageId,
            MemberRequestType requestType,
            boolean wpLeader,
            String message
    );

}
