package com.finconsgroup.itserr.marketplace.institutionalpage.dm.enums;

import com.fasterxml.jackson.annotation.JsonValue;
import lombok.Getter;

@Getter
public enum MemberRequestStatus {

    APPROVED("Approved"), REJECTED("Rejected"), CANCELLED("Cancelled");

    private final String label;

    MemberRequestStatus(String label) {
        this.label = label;
    }

    @JsonValue
    public String getLabel() {
        return label;
    }

    /**
     * It maps the label to a {@link MemberRequestStatus} object
     *
     * @param label the label to map to enum
     * @return {@link MemberRequestStatus} instance if found
     * @throws IllegalArgumentException if no matching instance found
     */
    public static MemberRequestStatus ofLabel(String label) {
        for (MemberRequestStatus memberRequestStatus : MemberRequestStatus.values()) {
            if (memberRequestStatus.label.equalsIgnoreCase(label)) {
                return memberRequestStatus;
            }
        }

        throw new IllegalArgumentException("Unsupported value: " + label);
    }
}
