package com.finconsgroup.itserr.marketplace.institutionalpage.dm.enums;

import com.fasterxml.jackson.annotation.JsonValue;
import lombok.Getter;

@Getter
public enum MemberRequestType {
    INVITATION("Invitation"), JOIN_REQUEST("JoinRequest");

    private final String label;

    MemberRequestType(String label) {
        this.label = label;
    }

    @JsonValue
    public String getLabel() {
        return label;
    }

    /**
     * It maps the label to a {@link MemberRequestType} object
     *
     * @param label the label to map to enum
     * @return {@link MemberRequestType} instance if found
     * @throws IllegalArgumentException if no matching instance found
     */
    public static MemberRequestType ofLabel(String label) {
        for (MemberRequestType memberRequestType : MemberRequestType.values()) {
            if (memberRequestType.label.equalsIgnoreCase(label)) {
                return memberRequestType;
            }
        }

        throw new IllegalArgumentException("Unsupported value: " + label);
    }
}
