package com.finconsgroup.itserr.marketplace.label.dm;

import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.info.Info;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.context.properties.ConfigurationPropertiesScan;
import org.springframework.data.web.config.EnableSpringDataWebSupport;

import static org.springframework.data.web.config.EnableSpringDataWebSupport.PageSerializationMode.VIA_DTO;

@SpringBootApplication
@EnableSpringDataWebSupport(pageSerializationMode = VIA_DTO)
@ConfigurationPropertiesScan
@OpenAPIDefinition(info = @Info(
        title = "Label Management Domain API",
        description = "API definition of the Label Management Domain Microservice",
        version = "1.0.0"
))
public class LabelDmApplication {

    public static void main(String[] args) {
        SpringApplication.run(LabelDmApplication.class, args);
    }

}
