package com.finconsgroup.itserr.marketplace.label.dm.repository;

import com.finconsgroup.itserr.marketplace.label.dm.entity.LabelEntity;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.lang.NonNull;

import java.util.UUID;

/**
 * Repository for operations related to {@link LabelEntity}
 */
public interface LabelRepository extends JpaRepository<LabelEntity, UUID> {
    /**
     * Counts the labels having given name and context.
     *
     * @param name    the name
     * @param context the context
     * @return Number of labels matching the name and context
     */
    int countByNameIgnoreCaseAndContextIgnoreCase(@NonNull String name, @NonNull String context);

    /**
     * Finds the labels for provided context.
     *
     * @param context  the context to search for
     * @param pageable the page request
     * @return the found page of label results
     */
    Page<LabelEntity> findByContextIgnoreCase(String context, Pageable pageable);

    /**
     * Finds the labels for provided context.
     *
     * @param context  the context to search for
     * @param name the name to match using starts with
     * @param pageable the page request
     * @return the found page of label results
     */
    Page<LabelEntity> findByContextIgnoreCaseAndNameStartsWithIgnoreCase(String context, String name, Pageable pageable);
}
