/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.label.dm.api;

import com.finconsgroup.itserr.marketplace.core.web.exception.ErrorResponseDto;
import com.finconsgroup.itserr.marketplace.label.dm.dto.InputCreateLabelDto;
import com.finconsgroup.itserr.marketplace.label.dm.dto.OutputLabelDto;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Positive;
import jakarta.validation.constraints.PositiveOrZero;
import java.util.UUID;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Sort;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;

@Tag(name="Label", description="Operations related to label management")
@SecurityRequirement(name="BearerAuth")
@ApiResponses(value={@ApiResponse(responseCode="500", description="Server Error", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponseDto.class))})})
public interface LabelApi {
    @Operation(summary="Create new label", description="Create a new label for the given context based onthe provided dto. It also performs validations and returns errors in case of validation failures")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="OK"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponseDto.class))})})
    @ResponseStatus(value=HttpStatus.CREATED)
    @PostMapping(value={"/label/labels"})
    public OutputLabelDto create(@Valid @RequestBody InputCreateLabelDto var1);

    @Operation(summary="Fetches label for the provided id", description="Fetches a label using the provided id.It returns not found response in case if the id does not exist")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponseDto.class))})})
    @GetMapping(value={"/label/labels/{labelId}"})
    @ResponseStatus(value=HttpStatus.OK)
    public OutputLabelDto get(@PathVariable(value="labelId") UUID var1);

    @Operation(summary="Deletes label for the provided id", description="Deletes a label using the provided id.It returns not found response in case if the id does not exist", hidden=true)
    @ApiResponses(value={@ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponseDto.class))})})
    @DeleteMapping(value={"/label/labels/{labelId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void delete(@PathVariable(value="labelId") UUID var1);

    @Operation(summary="Retrieve all labels matching the provided context", parameters={@Parameter(name="context", description="The context to search labels for"), @Parameter(name="name", description="The name to search labels containing it"), @Parameter(name="pageNumber", description="The page index, starting from 0"), @Parameter(name="pageSize", description="The number of items per page"), @Parameter(name="sort", description="The field by which to sort the results"), @Parameter(name="direction", description="The sorting direction: ASC or DESC")}, responses={@ApiResponse(responseCode="200", description="OK")})
    @ResponseStatus(value=HttpStatus.OK)
    @GetMapping(value={"/label/labels"}, produces={"application/json"})
    public Page<OutputLabelDto> findByContextAndName(@RequestParam(name="context") String var1, @RequestParam(name="name", required=false) String var2, @RequestParam(name="pageNumber", defaultValue="0", required=false) @PositiveOrZero int var3, @RequestParam(name="pageSize", defaultValue="10", required=false) @Positive int var4, @RequestParam(name="sort", defaultValue="id", required=false) String var5, @RequestParam(name="direction", defaultValue="ASC", required=false) Sort.Direction var6);
}

