package com.finconsgroup.itserr.marketplace.metadata.bs.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

import static com.finconsgroup.itserr.marketplace.metadata.bs.constants.Constants.METADATA_DESCRIPTION_LENGTH;
import static com.finconsgroup.itserr.marketplace.metadata.bs.constants.Constants.VALIDATION_ERROR_FIELD_LENGTH;

@Data
@SuperBuilder
@NoArgsConstructor
@AllArgsConstructor
@Schema(name = "InputModerationStatusDto", description = "DTO for setting moderation status")
public class InputModerationStatusDto {

    @Schema(description = "Moderation status", example = "APPROVED", requiredMode = Schema.RequiredMode.REQUIRED)
    @NotNull
    private ModerationResult status;

    @Schema(description = "Moderation message or feedback", example = "Metadata approved after review")
    @Size(max = METADATA_DESCRIPTION_LENGTH, message = VALIDATION_ERROR_FIELD_LENGTH)
    private String message;
}