package com.finconsgroup.itserr.marketplace.metadata.bs.mapper;

import com.finconsgroup.itserr.marketplace.metadata.bs.client.metadatadm.dto.InputCreateMetadataDmDto;
import com.finconsgroup.itserr.marketplace.metadata.bs.client.metadatadm.dto.InputModerationStatusDmDto;
import com.finconsgroup.itserr.marketplace.metadata.bs.client.metadatadm.dto.InputUpdateMetadataDmDto;
import com.finconsgroup.itserr.marketplace.metadata.bs.client.metadatadm.dto.OutputMetadataDmDto;
import com.finconsgroup.itserr.marketplace.metadata.bs.client.metadatadm.dto.OutputMetadataFieldDmDto;
import com.finconsgroup.itserr.marketplace.metadata.bs.client.metadatadm.dto.OutputMetadataFieldExtDmDto;
import com.finconsgroup.itserr.marketplace.metadata.bs.client.metadatadm.dto.OutputMetadataPreviewDmDto;
import com.finconsgroup.itserr.marketplace.metadata.bs.dto.InputCreateMetadataDto;
import com.finconsgroup.itserr.marketplace.metadata.bs.dto.InputModerationStatusDto;
import com.finconsgroup.itserr.marketplace.metadata.bs.dto.InputUpdateMetadataDto;
import com.finconsgroup.itserr.marketplace.metadata.bs.dto.OutputMetadataFieldDto;
import com.finconsgroup.itserr.marketplace.metadata.bs.dto.OutputMetadataFieldExtDto;
import com.finconsgroup.itserr.marketplace.metadata.bs.dto.OutputMetadataPreviewDto;
import com.finconsgroup.itserr.marketplace.metadata.bs.dto.OutputMetadataDto;
import com.finconsgroup.itserr.marketplace.metadata.bs.messaging.dto.MetadataCreatedMessageBodyDto;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;

/**
 * Metadata related mapper.
 */
@Mapper(config = MapperConfiguration.class, uses = {MetadataFieldMapper.class, UserProfileMapper.class})
public interface MetadataMapper {

    InputCreateMetadataDmDto dtoToClientDto(InputCreateMetadataDto src);

    InputUpdateMetadataDmDto dtoToClientDto(InputUpdateMetadataDto src);

    @Mapping(target = "creator", ignore = true)
    @Mapping(target = "updatedBy", ignore = true)
    OutputMetadataDto clientDtoToDto(OutputMetadataDmDto src);

    @Mapping(target = "creatorId", source = "src.creator.id")
    MetadataCreatedMessageBodyDto dtoToCreatedMessageDto(OutputMetadataDto src);

    InputModerationStatusDmDto dtoToClientDto(InputModerationStatusDto src);

    OutputMetadataFieldDto clientDtoToDto(OutputMetadataFieldDmDto src);

    @Mapping(target = "creator", ignore = true)
    OutputMetadataPreviewDto clientDtoToDto(OutputMetadataPreviewDmDto src);

    @Mapping(target = "metadata.creator", ignore = true)
    OutputMetadataFieldExtDto clientDtoToDto(OutputMetadataFieldExtDmDto src);
}
