package com.finconsgroup.itserr.marketplace.metadata.bs.service;

import com.finconsgroup.itserr.marketplace.core.web.dto.OutputPageDto;
import com.finconsgroup.itserr.marketplace.metadata.bs.dto.InputModerationStatusDto;
import com.finconsgroup.itserr.marketplace.metadata.bs.dto.ModerationStatus;
import com.finconsgroup.itserr.marketplace.metadata.bs.dto.OutputMetadataDto;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

import java.util.UUID;

/**
 * Service interface for metadata moderation operations.
 */
public interface MetadataModerationService {

    /**
     * Retrieves list of metadata for moderation.
     *
     * @param status   Filter by moderation status (PENDING or REJECTED). If null, returns both.
     * @return A paginated list of metadata for moderation
     */
    OutputPageDto<OutputMetadataDto> getMetadataListForModeration(ModerationStatus status, int pageNumber, int pageSize, String sort, Sort.Direction direction);

    /**
     * Retrieves a specific metadata for moderation.
     *
     * @param metadataId The unique identifier of the metadata
     * @return metadata
     */
    OutputMetadataDto getMetadataForModeration(UUID metadataId);

    /**
     * Sets the moderation status of a metadata.
     *
     * @param metadataId               The unique identifier of the metadata
     * @param inputModerationStatusDto The DTO containing the moderation status and optional message
     * @return The moderation DTO, with the operation type and the complete metadata DTO
     */
    OutputMetadataDto setModerationStatus(UUID metadataId, InputModerationStatusDto inputModerationStatusDto);
}
