package com.finconsgroup.itserr.marketplace.news.bs.client.dto.workspace;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

@EqualsAndHashCode(callSuper = true)
@Data
@SuperBuilder
@NoArgsConstructor
@AllArgsConstructor
@JsonIgnoreProperties(ignoreUnknown = true)
@Schema(
        name = "FolderD4SDto",
        description = "Represents a folder inside a workspace, extending ItemDto"
)
public class FolderDto extends ItemDto {

    @Schema(
            description = "User's associated with the folder, structured as a map of users",
            example = "map: {annn.surname89674" + "f14e38c9-2631-4780-ad02-99999/AnnnnFolder }"
    )
    private UsersDto users;

}
