package com.finconsgroup.itserr.marketplace.news.bs.controller;

import com.finconsgroup.itserr.marketplace.news.bs.api.ImageApi;
import com.finconsgroup.itserr.marketplace.news.bs.service.ImageService;
import com.finconsgroup.itserr.marketplace.news.bs.api.NewsApi;
import com.finconsgroup.itserr.marketplace.news.bs.client.dto.newsDm.OutputImageDto;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

/**
 * REST controller class for handling user image related API requests.
 *
 * <p>Implements the {@link NewsApi} interface.</p>
 */
@Slf4j
@RequiredArgsConstructor
@RestController
public class ImageController implements ImageApi {
    private final ImageService imageService;

    @Override
    public OutputImageDto createPublicImage(MultipartFile file) {
        return imageService.createPublicImage(file);
    }

    @Override
    public OutputImageDto updatePublicImage(String id, MultipartFile file) {
        return imageService.updatePublicImage(id, file);
    }
}
