package com.finconsgroup.itserr.marketplace.news.bs.mapper;

import com.finconsgroup.itserr.marketplace.news.bs.dto.OutputNewsDetailDto;
import com.finconsgroup.itserr.marketplace.news.bs.messaging.dto.NewsCreatedMessageBodyDto;
import com.finconsgroup.itserr.marketplace.news.bs.messaging.dto.NewsDeletedMessageBodyDto;
import com.finconsgroup.itserr.marketplace.news.bs.messaging.dto.NewsMessagingAdditionalDataDto;
import com.finconsgroup.itserr.marketplace.news.bs.messaging.dto.NewsUpdatedMessageBodyDto;
import com.finconsgroup.itserr.messaging.dto.MessagingEventDto;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;

@Mapper(config = MapperConfiguration.class)
public interface NewsMapper {

    /**
     * Converts a {@link OutputNewsDetailDto} into a {@link NewsCreatedMessageBodyDto}.
     *
     * @param outputNewsDetailDto news item.
     * @return Created document DTO.
     */
    NewsCreatedMessageBodyDto toNewsCreatedMessageBodyDto(OutputNewsDetailDto outputNewsDetailDto);

    /**
     * Converts a {@link OutputNewsDetailDto} into a {@link NewsUpdatedMessageBodyDto}.
     *
     * @param outputNewsDetailDto news item.
     * @return Created document DTO.
     */
    NewsUpdatedMessageBodyDto toNewsUpdatedMessageBodyDto(OutputNewsDetailDto outputNewsDetailDto);

    /**
     * Converts a {@link OutputNewsDetailDto} into a {@link NewsDeletedMessageBodyDto}.
     *
     * @param outputNewsDetailDto news item.
     * @return Created document DTO.
     */
    NewsDeletedMessageBodyDto toNewsDeletedMessageBodyDto(OutputNewsDetailDto outputNewsDetailDto);

    /**
     * Converts a {@link OutputNewsDetailDto} into a {@link MessagingEventDto}.
     *
     * @param outputNewsDetailDto news item.
     * @return Created messaging event DTO.
     */
    @Mapping(target = "name", ignore = true)
    @Mapping(target = "status", ignore = true)
    @Mapping(target = "category", source = "outputNewsDetailDto.newsType")
    @Mapping(target = "timestamp", ignore = true)
    @Mapping(target = "user", ignore = true)
    @Mapping(target = "message", ignore = true)
    @Mapping(target = "additionalData", ignore = true)
    MessagingEventDto<NewsMessagingAdditionalDataDto> toMessagingEventDto(OutputNewsDetailDto outputNewsDetailDto);

}
