package com.finconsgroup.itserr.marketplace.news.bs.messaging.impl;


import com.finconsgroup.itserr.marketplace.news.bs.messaging.EventProducer;
import com.finconsgroup.itserr.messaging.dto.MessagingEventDto;
import lombok.extern.slf4j.Slf4j;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

/**
 * Local stub implementation of {@link EventProducer}.
 * <p>
 * This implementation does not send any real messages but logs the invocation for testing purposes.
 */
@Component
@ConditionalOnProperty(name = "messaging.enabled", havingValue = "false")
@Slf4j
public class LoggerEventProducer implements EventProducer {

    @Override
    public void publishCreateEvent(@NotNull MessagingEventDto<?> resource) {
        log.info("Message dispatch skipped (local profile) - CREATED event for resource: {}", resource);
    }

    @Override
    public void publishUpdateEvent(@NotNull MessagingEventDto<?> resource) {
        log.info("Message dispatch skipped (local profile) - UPDATED event for resource: {}", resource);
    }

    @Override
    public void publishDeleteEvent(@NotNull MessagingEventDto<?> resource) {
        log.info("Message dispatch skipped (local profile) - DELETED event for resource: {}", resource);
    }
}