package com.finconsgroup.itserr.marketplace.news.bs.openapi;

import io.swagger.v3.oas.models.servers.Server;
import org.springdoc.core.customizers.OpenApiCustomizer;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.List;

@Configuration
public class OpenApiConfiguration {

    @Value("${news.bs.swagger-api-server-url}")
    private String swaggerApiServer;

    @Bean
    public OpenApiCustomizer customServerOpenApiCustomizer() {
        return openApi -> openApi
                .setServers(List.of(new Server().url(swaggerApiServer)));
    }
}
