package com.finconsgroup.itserr.marketplace.news.bs.service.impl;

import com.finconsgroup.itserr.marketplace.core.web.dto.OutputPageDto;
import com.finconsgroup.itserr.marketplace.news.bs.bean.DetailRequest;
import com.finconsgroup.itserr.marketplace.news.bs.client.UserProfileDmClient;
import com.finconsgroup.itserr.marketplace.news.bs.client.dto.userprofile.InputFindUserProfilesByIdsDto;
import com.finconsgroup.itserr.marketplace.news.bs.dto.OutputNewsAuthorDto;
import com.finconsgroup.itserr.marketplace.news.bs.client.dto.userprofile.OutputUserProfileDto;
import com.finconsgroup.itserr.marketplace.news.bs.service.NewsAuthorDetailProvider;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;

/**
 * Implementation of {@link NewsAuthorDetailProvider} for News
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class DefaultNewsAuthorDetailProvider implements NewsAuthorDetailProvider {

    private final UserProfileDmClient userProfileDmClient;

    @NonNull
    @Override
    public OutputPageDto<OutputNewsAuthorDto> getDetails(@NonNull DetailRequest request) {

        if (request.getResourceIds() == null || request.getResourceIds().isEmpty()) {
            return OutputPageDto.emptyWithPageSize(request.getPageRequestDto().getPageSize());
        }

        InputFindUserProfilesByIdsDto inputFindUserProfilesByIdsDto = InputFindUserProfilesByIdsDto
                .builder()
                .ids(request.getResourceIds().stream().toList())
                .build();

        return userProfileDmClient.findAllByIds(
                        inputFindUserProfilesByIdsDto,
                        request.getPageRequestDto().getPageNumber(),
                        request.getPageRequestDto().getPageSize(),
                        request.getPageRequestDto().getSort(),
                        request.getPageRequestDto().getDirection())
                .map(this::mapFromUserProfileDto);
    }

    /**
     * Maps the response from user profile domain service to news author dto
     *
     * @param userProfileDto the user profile dto to map from
     * @return the mapped {@link OutputNewsAuthorDto}
     */
    private OutputNewsAuthorDto mapFromUserProfileDto(OutputUserProfileDto userProfileDto) {
        return OutputNewsAuthorDto
                .builder()
                .id(userProfileDto.getId())
                .firstName(userProfileDto.getFirstName())
                .lastName(userProfileDto.getLastName())
                .orcid(userProfileDto.getOrcid())
                .email(userProfileDto.getEmail())
                .location(userProfileDto.getWorkingLocation())
                .build();
    }
}
