/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.news.bs.api;

import com.finconsgroup.itserr.marketplace.core.web.dto.OutputPageDto;
import com.finconsgroup.itserr.marketplace.core.web.exception.ErrorResponseDto;
import com.finconsgroup.itserr.marketplace.news.bs.client.dto.newsDm.InputCreateNewsDto;
import com.finconsgroup.itserr.marketplace.news.bs.client.dto.newsDm.InputUpdateNewsDto;
import com.finconsgroup.itserr.marketplace.news.bs.dto.OutputNewsDetailDto;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Positive;
import jakarta.validation.constraints.PositiveOrZero;
import java.util.UUID;
import org.springframework.data.domain.Sort;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;

@Tag(name="NewsApi", description="The NewsApi API: it provides endpoints for retrieving, creating, updating, and deleting news.")
@SecurityRequirement(name="BearerAuth")
public interface NewsApi {
    @Operation(summary="find all the news", responses={@ApiResponse(responseCode="200", description="OK")})
    @GetMapping(value={"/news/news"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public OutputPageDto<OutputNewsDetailDto> findAll(@RequestParam(name="pageNumber", defaultValue="0", required=false) @PositiveOrZero int var1, @RequestParam(name="pageSize", defaultValue="10", required=false) @Positive int var2, @RequestParam(name="sort", defaultValue="creationTime", required=false) String var3, @RequestParam(name="direction", defaultValue="DESC", required=false) Sort.Direction var4);

    @Operation(summary="find news by id", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponseDto.class))})})
    @GetMapping(value={"/news/news/{id}"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public OutputNewsDetailDto findById(@PathVariable(value="id") UUID var1);

    @Operation(summary="create a news", responses={@ApiResponse(responseCode="201", description="Created")})
    @PostMapping(value={"/news/news"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public OutputNewsDetailDto createNews(@Valid @RequestBody InputCreateNewsDto var1);

    @Operation(summary="updates news by id", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponseDto.class))})})
    @PutMapping(value={"/news/news/{id}"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public OutputNewsDetailDto updateNewsById(@PathVariable(value="id") UUID var1, @Valid @RequestBody InputUpdateNewsDto var2);

    @Operation(summary="delete a news by id", responses={@ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponseDto.class))})})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @DeleteMapping(value={"/news/news/{id}"})
    public void deleteNewsById(@PathVariable(value="id") UUID var1);
}

