/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.news.bs.client.dto.newsDm;

import com.finconsgroup.itserr.marketplace.news.bs.client.dto.newsDm.InputAuthorDto;
import com.finconsgroup.itserr.marketplace.news.bs.client.dto.newsDm.InputCreateNewsDto;
import com.finconsgroup.itserr.marketplace.news.bs.client.dto.newsDm.InputImageDto;
import com.finconsgroup.itserr.marketplace.news.bs.client.dto.newsDm.InputInstitutionalPageDto;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.Size;
import java.util.List;
import lombok.Generated;

@Schema(name="InputCreateNewsDto", description="DTO for creating news")
public class InputCreateNewsDto {
    @Schema(description="The title of the news", example="Annual Tech Conference 2025")
    @NotBlank(message="required field")
    @Size(max=255, message="field length must be between {min} and {max}")
    private @NotBlank(message="required field") @Size(max=255, message="field length must be between {min} and {max}") String title;
    @Schema(description="The type of news", example="Technology")
    @Size(max=50, message="field length must be between {min} and {max}")
    private @Size(max=50, message="field length must be between {min} and {max}") String newsType;
    @Schema(description="The content of the news", example="Join us for the biggest tech conference of the year...")
    @Size(max=8000, message="field length must be between {min} and {max}")
    private @Size(max=8000, message="field length must be between {min} and {max}") String content;
    @Schema(description="List of tags associated with the news", example="[\"technology\", \"conference\", \"innovation\"]")
    private List<String> tags;
    @Schema(description="List of institutional pages")
    private List<InputInstitutionalPageDto> institutionalPages;
    @Valid
    private InputImageDto image;
    @Schema(description="List of unregistered authors")
    @Valid
    private List<InputAuthorDto> unRegisteredAuthors;
    @Schema(description="List of registered authors", example="[\"123e4567-e89b-12d3-a456-426614174002\", \"123e4567-e89b-12d3-a456-426614174003\"]")
    private List<String> registeredAuthorIds;

    @Generated
    public static InputCreateNewsDtoBuilder builder() {
        return new InputCreateNewsDtoBuilder();
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public String getNewsType() {
        return this.newsType;
    }

    @Generated
    public String getContent() {
        return this.content;
    }

    @Generated
    public List<String> getTags() {
        return this.tags;
    }

    @Generated
    public List<InputInstitutionalPageDto> getInstitutionalPages() {
        return this.institutionalPages;
    }

    @Generated
    public InputImageDto getImage() {
        return this.image;
    }

    @Generated
    public List<InputAuthorDto> getUnRegisteredAuthors() {
        return this.unRegisteredAuthors;
    }

    @Generated
    public List<String> getRegisteredAuthorIds() {
        return this.registeredAuthorIds;
    }

    @Generated
    public void setTitle(String title) {
        this.title = title;
    }

    @Generated
    public void setNewsType(String newsType) {
        this.newsType = newsType;
    }

    @Generated
    public void setContent(String content) {
        this.content = content;
    }

    @Generated
    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    @Generated
    public void setInstitutionalPages(List<InputInstitutionalPageDto> institutionalPages) {
        this.institutionalPages = institutionalPages;
    }

    @Generated
    public void setImage(InputImageDto image) {
        this.image = image;
    }

    @Generated
    public void setUnRegisteredAuthors(List<InputAuthorDto> unRegisteredAuthors) {
        this.unRegisteredAuthors = unRegisteredAuthors;
    }

    @Generated
    public void setRegisteredAuthorIds(List<String> registeredAuthorIds) {
        this.registeredAuthorIds = registeredAuthorIds;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InputCreateNewsDto)) {
            return false;
        }
        InputCreateNewsDto other = (InputCreateNewsDto)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$newsType = this.getNewsType();
        String other$newsType = other.getNewsType();
        if (this$newsType == null ? other$newsType != null : !this$newsType.equals(other$newsType)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        List this$tags = this.getTags();
        List other$tags = other.getTags();
        if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
            return false;
        }
        List this$institutionalPages = this.getInstitutionalPages();
        List other$institutionalPages = other.getInstitutionalPages();
        if (this$institutionalPages == null ? other$institutionalPages != null : !((Object)this$institutionalPages).equals(other$institutionalPages)) {
            return false;
        }
        InputImageDto this$image = this.getImage();
        InputImageDto other$image = other.getImage();
        if (this$image == null ? other$image != null : !this$image.equals(other$image)) {
            return false;
        }
        List this$unRegisteredAuthors = this.getUnRegisteredAuthors();
        List other$unRegisteredAuthors = other.getUnRegisteredAuthors();
        if (this$unRegisteredAuthors == null ? other$unRegisteredAuthors != null : !((Object)this$unRegisteredAuthors).equals(other$unRegisteredAuthors)) {
            return false;
        }
        List this$registeredAuthorIds = this.getRegisteredAuthorIds();
        List other$registeredAuthorIds = other.getRegisteredAuthorIds();
        return !(this$registeredAuthorIds == null ? other$registeredAuthorIds != null : !((Object)this$registeredAuthorIds).equals(other$registeredAuthorIds));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof InputCreateNewsDto;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $newsType = this.getNewsType();
        result = result * 59 + ($newsType == null ? 43 : $newsType.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        List $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        List $institutionalPages = this.getInstitutionalPages();
        result = result * 59 + ($institutionalPages == null ? 43 : ((Object)$institutionalPages).hashCode());
        InputImageDto $image = this.getImage();
        result = result * 59 + ($image == null ? 43 : $image.hashCode());
        List $unRegisteredAuthors = this.getUnRegisteredAuthors();
        result = result * 59 + ($unRegisteredAuthors == null ? 43 : ((Object)$unRegisteredAuthors).hashCode());
        List $registeredAuthorIds = this.getRegisteredAuthorIds();
        result = result * 59 + ($registeredAuthorIds == null ? 43 : ((Object)$registeredAuthorIds).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "InputCreateNewsDto(title=" + this.getTitle() + ", newsType=" + this.getNewsType() + ", content=" + this.getContent() + ", tags=" + String.valueOf(this.getTags()) + ", institutionalPages=" + String.valueOf(this.getInstitutionalPages()) + ", image=" + String.valueOf(this.getImage()) + ", unRegisteredAuthors=" + String.valueOf(this.getUnRegisteredAuthors()) + ", registeredAuthorIds=" + String.valueOf(this.getRegisteredAuthorIds()) + ")";
    }

    @Generated
    public InputCreateNewsDto(String title, String newsType, String content, List<String> tags, List<InputInstitutionalPageDto> institutionalPages, InputImageDto image, List<InputAuthorDto> unRegisteredAuthors, List<String> registeredAuthorIds) {
        this.title = title;
        this.newsType = newsType;
        this.content = content;
        this.tags = tags;
        this.institutionalPages = institutionalPages;
        this.image = image;
        this.unRegisteredAuthors = unRegisteredAuthors;
        this.registeredAuthorIds = registeredAuthorIds;
    }
}

