/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.news.bs.client.dto.newsDm;

import com.finconsgroup.itserr.marketplace.news.bs.client.dto.newsDm.OutputAuthorDto;
import com.finconsgroup.itserr.marketplace.news.bs.client.dto.newsDm.OutputImageDto;
import com.finconsgroup.itserr.marketplace.news.bs.client.dto.newsDm.OutputInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.news.bs.client.dto.newsDm.OutputNewsDto;
import io.swagger.v3.oas.annotations.media.Schema;
import java.time.Instant;
import java.util.List;
import java.util.UUID;
import lombok.Generated;

@Schema(name="OutputNewsDto", description="DTO representing a news in responses")
public class OutputNewsDto {
    @Schema(description="Unique identifier of the news", example="550e8400-e29b-41d4-a716-446655440000")
    private UUID id;
    @Schema(description="The title of the news", example="Annual Tech Conference 2025")
    private String title;
    @Schema(description="The ID of the creator", example="f81d4fae-7dec-11d0-a765-00a0c91e6bf6")
    private UUID creatorId;
    @Schema(description="The type of news", example="Technology")
    private String newsType;
    @Schema(description="The content of the news")
    private String content;
    @Schema(description="List of tags associated with the news")
    private List<String> tags;
    @Schema(description="List of institutional pages")
    private List<OutputInstitutionalPageDto> institutionalPages;
    @Schema(description="Image")
    private OutputImageDto image;
    @Schema(description="List of unregistered authors")
    private List<OutputAuthorDto> unRegisteredAuthors;
    @Schema(description="List of registered authors", example="[\"123e4567-e89b-12d3-a456-426614174002\", \"123e4567-e89b-12d3-a456-426614174003\"]")
    private List<String> registeredAuthorIds;
    @Schema(description="The creation time of the table record", example="2025-06-20T15:29:06.254836Z")
    private Instant creationTime;
    @Schema(description="The last update time of the table record", example="2025-06-20T15:29:06.254836Z")
    private Instant updateTime;

    @Generated
    public static OutputNewsDtoBuilder builder() {
        return new OutputNewsDtoBuilder();
    }

    @Generated
    public UUID getId() {
        return this.id;
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public UUID getCreatorId() {
        return this.creatorId;
    }

    @Generated
    public String getNewsType() {
        return this.newsType;
    }

    @Generated
    public String getContent() {
        return this.content;
    }

    @Generated
    public List<String> getTags() {
        return this.tags;
    }

    @Generated
    public List<OutputInstitutionalPageDto> getInstitutionalPages() {
        return this.institutionalPages;
    }

    @Generated
    public OutputImageDto getImage() {
        return this.image;
    }

    @Generated
    public List<OutputAuthorDto> getUnRegisteredAuthors() {
        return this.unRegisteredAuthors;
    }

    @Generated
    public List<String> getRegisteredAuthorIds() {
        return this.registeredAuthorIds;
    }

    @Generated
    public Instant getCreationTime() {
        return this.creationTime;
    }

    @Generated
    public Instant getUpdateTime() {
        return this.updateTime;
    }

    @Generated
    public void setId(UUID id) {
        this.id = id;
    }

    @Generated
    public void setTitle(String title) {
        this.title = title;
    }

    @Generated
    public void setCreatorId(UUID creatorId) {
        this.creatorId = creatorId;
    }

    @Generated
    public void setNewsType(String newsType) {
        this.newsType = newsType;
    }

    @Generated
    public void setContent(String content) {
        this.content = content;
    }

    @Generated
    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    @Generated
    public void setInstitutionalPages(List<OutputInstitutionalPageDto> institutionalPages) {
        this.institutionalPages = institutionalPages;
    }

    @Generated
    public void setImage(OutputImageDto image) {
        this.image = image;
    }

    @Generated
    public void setUnRegisteredAuthors(List<OutputAuthorDto> unRegisteredAuthors) {
        this.unRegisteredAuthors = unRegisteredAuthors;
    }

    @Generated
    public void setRegisteredAuthorIds(List<String> registeredAuthorIds) {
        this.registeredAuthorIds = registeredAuthorIds;
    }

    @Generated
    public void setCreationTime(Instant creationTime) {
        this.creationTime = creationTime;
    }

    @Generated
    public void setUpdateTime(Instant updateTime) {
        this.updateTime = updateTime;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OutputNewsDto)) {
            return false;
        }
        OutputNewsDto other = (OutputNewsDto)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        UUID this$creatorId = this.getCreatorId();
        UUID other$creatorId = other.getCreatorId();
        if (this$creatorId == null ? other$creatorId != null : !((Object)this$creatorId).equals(other$creatorId)) {
            return false;
        }
        String this$newsType = this.getNewsType();
        String other$newsType = other.getNewsType();
        if (this$newsType == null ? other$newsType != null : !this$newsType.equals(other$newsType)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        List this$tags = this.getTags();
        List other$tags = other.getTags();
        if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
            return false;
        }
        List this$institutionalPages = this.getInstitutionalPages();
        List other$institutionalPages = other.getInstitutionalPages();
        if (this$institutionalPages == null ? other$institutionalPages != null : !((Object)this$institutionalPages).equals(other$institutionalPages)) {
            return false;
        }
        OutputImageDto this$image = this.getImage();
        OutputImageDto other$image = other.getImage();
        if (this$image == null ? other$image != null : !this$image.equals(other$image)) {
            return false;
        }
        List this$unRegisteredAuthors = this.getUnRegisteredAuthors();
        List other$unRegisteredAuthors = other.getUnRegisteredAuthors();
        if (this$unRegisteredAuthors == null ? other$unRegisteredAuthors != null : !((Object)this$unRegisteredAuthors).equals(other$unRegisteredAuthors)) {
            return false;
        }
        List this$registeredAuthorIds = this.getRegisteredAuthorIds();
        List other$registeredAuthorIds = other.getRegisteredAuthorIds();
        if (this$registeredAuthorIds == null ? other$registeredAuthorIds != null : !((Object)this$registeredAuthorIds).equals(other$registeredAuthorIds)) {
            return false;
        }
        Instant this$creationTime = this.getCreationTime();
        Instant other$creationTime = other.getCreationTime();
        if (this$creationTime == null ? other$creationTime != null : !((Object)this$creationTime).equals(other$creationTime)) {
            return false;
        }
        Instant this$updateTime = this.getUpdateTime();
        Instant other$updateTime = other.getUpdateTime();
        return !(this$updateTime == null ? other$updateTime != null : !((Object)this$updateTime).equals(other$updateTime));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OutputNewsDto;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        UUID $creatorId = this.getCreatorId();
        result = result * 59 + ($creatorId == null ? 43 : ((Object)$creatorId).hashCode());
        String $newsType = this.getNewsType();
        result = result * 59 + ($newsType == null ? 43 : $newsType.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        List $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        List $institutionalPages = this.getInstitutionalPages();
        result = result * 59 + ($institutionalPages == null ? 43 : ((Object)$institutionalPages).hashCode());
        OutputImageDto $image = this.getImage();
        result = result * 59 + ($image == null ? 43 : $image.hashCode());
        List $unRegisteredAuthors = this.getUnRegisteredAuthors();
        result = result * 59 + ($unRegisteredAuthors == null ? 43 : ((Object)$unRegisteredAuthors).hashCode());
        List $registeredAuthorIds = this.getRegisteredAuthorIds();
        result = result * 59 + ($registeredAuthorIds == null ? 43 : ((Object)$registeredAuthorIds).hashCode());
        Instant $creationTime = this.getCreationTime();
        result = result * 59 + ($creationTime == null ? 43 : ((Object)$creationTime).hashCode());
        Instant $updateTime = this.getUpdateTime();
        result = result * 59 + ($updateTime == null ? 43 : ((Object)$updateTime).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "OutputNewsDto(id=" + String.valueOf(this.getId()) + ", title=" + this.getTitle() + ", creatorId=" + String.valueOf(this.getCreatorId()) + ", newsType=" + this.getNewsType() + ", content=" + this.getContent() + ", tags=" + String.valueOf(this.getTags()) + ", institutionalPages=" + String.valueOf(this.getInstitutionalPages()) + ", image=" + String.valueOf(this.getImage()) + ", unRegisteredAuthors=" + String.valueOf(this.getUnRegisteredAuthors()) + ", registeredAuthorIds=" + String.valueOf(this.getRegisteredAuthorIds()) + ", creationTime=" + String.valueOf(this.getCreationTime()) + ", updateTime=" + String.valueOf(this.getUpdateTime()) + ")";
    }

    @Generated
    public OutputNewsDto(UUID id, String title, UUID creatorId, String newsType, String content, List<String> tags, List<OutputInstitutionalPageDto> institutionalPages, OutputImageDto image, List<OutputAuthorDto> unRegisteredAuthors, List<String> registeredAuthorIds, Instant creationTime, Instant updateTime) {
        this.id = id;
        this.title = title;
        this.creatorId = creatorId;
        this.newsType = newsType;
        this.content = content;
        this.tags = tags;
        this.institutionalPages = institutionalPages;
        this.image = image;
        this.unRegisteredAuthors = unRegisteredAuthors;
        this.registeredAuthorIds = registeredAuthorIds;
        this.creationTime = creationTime;
        this.updateTime = updateTime;
    }
}

