/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.news.bs.service.impl;

import com.finconsgroup.itserr.marketplace.core.web.exception.WP2ResourceNotFoundException;
import com.finconsgroup.itserr.marketplace.news.bs.client.WorkspaceBsClient;
import com.finconsgroup.itserr.marketplace.news.bs.client.dto.newsDm.OutputImageDto;
import com.finconsgroup.itserr.marketplace.news.bs.client.dto.workspace.FolderDto;
import com.finconsgroup.itserr.marketplace.news.bs.client.dto.workspace.InputFolderCreateDto;
import com.finconsgroup.itserr.marketplace.news.bs.client.dto.workspace.OutputPublicImageDto;
import com.finconsgroup.itserr.marketplace.news.bs.client.dto.workspace.WorkspaceDto;
import com.finconsgroup.itserr.marketplace.news.bs.config.properties.NewsBsConfigurationProperties;
import com.finconsgroup.itserr.marketplace.news.bs.service.ImageService;
import com.finconsgroup.itserr.marketplace.news.bs.util.Constants;
import feign.FeignException;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class DefaultImageService
implements ImageService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultImageService.class);
    private final WorkspaceBsClient workspaceBsClient;
    private final NewsBsConfigurationProperties newsBsConfigurationProperties;

    @NonNull
    public OutputImageDto createPublicImage(@NonNull MultipartFile file) {
        String folderId = this.getOrCreateImagesFolder();
        OutputPublicImageDto wsOutputPublicImageWSDto = this.workspaceBsClient.createPublicImage(folderId, file);
        return DefaultImageService.mapOutputPublicImageDto((OutputPublicImageDto)wsOutputPublicImageWSDto);
    }

    @NonNull
    public OutputImageDto updatePublicImage(@NonNull String id, @NonNull MultipartFile file) {
        OutputPublicImageDto wsOutputPublicImageWSDto = this.workspaceBsClient.updatePublicImage(id, file);
        return DefaultImageService.mapOutputPublicImageDto((OutputPublicImageDto)wsOutputPublicImageWSDto);
    }

    private String getOrCreateImagesFolder() {
        WorkspaceDto workspace = this.workspaceBsClient.getWorkspace();
        try {
            FolderDto folder = this.workspaceBsClient.getFolderByParentFolderIdAndName(workspace.getId(), this.newsBsConfigurationProperties.getImagesFolderName());
            return folder.getId();
        }
        catch (WP2ResourceNotFoundException | FeignException.NotFound e) {
            return this.workspaceBsClient.createFolderByFolderId(workspace.getId(), this.getImagesFolderPayload());
        }
    }

    private InputFolderCreateDto getImagesFolderPayload() {
        return InputFolderCreateDto.builder().name(this.newsBsConfigurationProperties.getImagesFolderName()).description("Containing info about the news and events created by the current user").hidden(Constants.HIDDEN_FOLDER_FLAG).build();
    }

    private static OutputImageDto mapOutputPublicImageDto(OutputPublicImageDto outputPublicImageDto) {
        return OutputImageDto.builder().id(UUID.fromString(outputPublicImageDto.getId())).url(outputPublicImageDto.getPublicLink()).build();
    }

    @Generated
    public DefaultImageService(WorkspaceBsClient workspaceBsClient, NewsBsConfigurationProperties newsBsConfigurationProperties) {
        this.workspaceBsClient = workspaceBsClient;
        this.newsBsConfigurationProperties = newsBsConfigurationProperties;
    }
}

