/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.news.bs.service.impl;

import com.finconsgroup.itserr.marketplace.core.web.dto.OutputPageDto;
import com.finconsgroup.itserr.marketplace.core.web.dto.PageRequestDto;
import com.finconsgroup.itserr.marketplace.news.bs.bean.DetailRequest;
import com.finconsgroup.itserr.marketplace.news.bs.bean.NewsApplicationEvent;
import com.finconsgroup.itserr.marketplace.news.bs.client.NewsDmClient;
import com.finconsgroup.itserr.marketplace.news.bs.client.dto.newsDm.InputCreateNewsDto;
import com.finconsgroup.itserr.marketplace.news.bs.client.dto.newsDm.InputUpdateNewsDto;
import com.finconsgroup.itserr.marketplace.news.bs.client.dto.newsDm.OutputAuthorDto;
import com.finconsgroup.itserr.marketplace.news.bs.client.dto.newsDm.OutputInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.news.bs.client.dto.newsDm.OutputNewsDto;
import com.finconsgroup.itserr.marketplace.news.bs.dto.OutputNewsAuthorDto;
import com.finconsgroup.itserr.marketplace.news.bs.dto.OutputNewsDetailDto;
import com.finconsgroup.itserr.marketplace.news.bs.dto.OutputNewsInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.news.bs.enums.EventType;
import com.finconsgroup.itserr.marketplace.news.bs.service.NewsAuthorDetailProvider;
import com.finconsgroup.itserr.marketplace.news.bs.service.NewsInstitutionalPageProvider;
import com.finconsgroup.itserr.marketplace.news.bs.service.NewsService;
import jakarta.validation.constraints.NotEmpty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.domain.Sort;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;

@Service
public class DefaultNewsService
implements NewsService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultNewsService.class);
    private final NewsDmClient newsDmClient;
    private final NewsAuthorDetailProvider newsAuthorDetailProvider;
    private final NewsInstitutionalPageProvider newsInstitutionalPageProvider;
    private final ApplicationEventPublisher applicationEventPublisher;

    @NonNull
    public OutputPageDto<OutputNewsDetailDto> findAll(@NonNull int pageNumber, @NonNull int pageSize, @NonNull String sort, @NonNull Sort.Direction direction) {
        OutputPageDto outputPageNewsDto = this.newsDmClient.findAll(pageNumber, pageSize, sort, direction);
        if (outputPageNewsDto.getContent().isEmpty()) {
            return OutputPageDto.emptyWithPage((OutputPageDto.Page)outputPageNewsDto.getPage());
        }
        return this.getDetailsForNews(outputPageNewsDto);
    }

    @NonNull
    private OutputPageDto<OutputNewsDetailDto> getDetailsForNews(@NotNull OutputPageDto<OutputNewsDto> detailProvider) {
        List<UUID> userIds = Stream.concat(detailProvider.getContent().stream().flatMap(dto -> Optional.ofNullable(dto.getRegisteredAuthorIds()).orElse(Collections.emptyList()).stream().map(UUID::fromString)), detailProvider.getContent().stream().map(OutputNewsDto::getCreatorId).filter(Objects::nonNull)).distinct().toList();
        List institutionalPageIds = detailProvider.getContent().stream().flatMap(dto -> Optional.ofNullable(dto.getInstitutionalPages()).map(institutionalPages -> institutionalPages.stream().map(OutputInstitutionalPageDto::getId).toList()).orElse(Collections.emptyList()).stream()).distinct().toList();
        Map userDetailByUserId = this.getUserDetailById(userIds);
        Map institutionalPageById = this.getInstitutionalPageById(institutionalPageIds);
        ArrayList outputNewsDetailDtoList = new ArrayList();
        detailProvider.getContent().forEach(outputNewsDto -> {
            OutputNewsDetailDto outputNewsDetailDto = this.buildAndEnrichNewsDetailDto(outputNewsDto, userDetailByUserId, institutionalPageById);
            outputNewsDetailDtoList.add(outputNewsDetailDto);
        });
        return OutputPageDto.builder().content(outputNewsDetailDtoList).page(detailProvider.getPage()).build();
    }

    @NonNull
    public OutputNewsDetailDto findById(@NonNull UUID newsId) {
        OutputNewsDto outputNewsDto = this.newsDmClient.findById(newsId);
        return this.getDetailsForNews(outputNewsDto);
    }

    @NonNull
    public OutputNewsDetailDto create(@NotNull InputCreateNewsDto inputCreateNewsDto) {
        OutputNewsDto outputNewsDto = this.newsDmClient.createNews(inputCreateNewsDto);
        OutputNewsDetailDto outputNewsDetailDto = this.getDetailsForNews(outputNewsDto);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new NewsApplicationEvent(outputNewsDetailDto, EventType.CREATED));
        return outputNewsDetailDto;
    }

    @NonNull
    public OutputNewsDetailDto updateById(@NotNull UUID newsId, @NotNull InputUpdateNewsDto inputUpdateNewsDto) {
        OutputNewsDto outputNewsDto = this.newsDmClient.updateNewsById(newsId, inputUpdateNewsDto);
        OutputNewsDetailDto outputNewsDetailDto = this.getDetailsForNews(outputNewsDto);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new NewsApplicationEvent(outputNewsDetailDto, EventType.UPDATED));
        return outputNewsDetailDto;
    }

    public void deleteById(@NotNull UUID newsId) {
        this.newsDmClient.deleteNewsById(newsId);
        OutputNewsDetailDto outputNewsDetailDto = OutputNewsDetailDto.builder().id(newsId).build();
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new NewsApplicationEvent(outputNewsDetailDto, EventType.DELETED));
    }

    @NonNull
    private OutputNewsDetailDto getDetailsForNews(@NotNull OutputNewsDto outputNewsDto) {
        List<UUID> userIds = Stream.concat(outputNewsDto.getRegisteredAuthorIds().stream().map(UUID::fromString), Stream.of(outputNewsDto.getCreatorId())).distinct().toList();
        List institutionalPageIds = Optional.ofNullable(outputNewsDto.getInstitutionalPages()).map(institutionalPages -> institutionalPages.stream().map(OutputInstitutionalPageDto::getId).toList()).orElse(List.of());
        Map userDetailByUserId = this.getUserDetailById(userIds);
        Map institutionalPageById = this.getInstitutionalPageById(institutionalPageIds);
        return this.buildAndEnrichNewsDetailDto(outputNewsDto, userDetailByUserId, institutionalPageById);
    }

    @NonNull
    private Map<UUID, OutputNewsAuthorDto> getUserDetailById(@NotEmpty List<UUID> userIds) {
        try {
            OutputPageDto outputAuthorDetailPageDto = this.newsAuthorDetailProvider.getDetails(DetailRequest.builder().resourceIds(userIds).pageRequestDto(PageRequestDto.builder().pageNumber(0).pageSize(userIds.size()).build()).build());
            return outputAuthorDetailPageDto.getContent().stream().collect(Collectors.toMap(OutputNewsAuthorDto::getId, Function.identity()));
        }
        catch (Exception e) {
            log.error("Failed to fetch user profiles for ids: {}", userIds, (Object)e);
            return userIds.stream().collect(Collectors.toMap(id -> id, id -> OutputNewsAuthorDto.builder().id(id).build()));
        }
    }

    @NonNull
    private Map<UUID, OutputNewsInstitutionalPageDto> getInstitutionalPageById(@NotEmpty List<UUID> institutionalPageIds) {
        try {
            OutputPageDto institutionalPageProviderDetails = this.newsInstitutionalPageProvider.getDetails(DetailRequest.builder().resourceIds(institutionalPageIds).pageRequestDto(PageRequestDto.builder().pageNumber(0).pageSize(institutionalPageIds.size()).build()).build());
            return institutionalPageProviderDetails.getContent().stream().collect(Collectors.toMap(OutputNewsInstitutionalPageDto::getId, Function.identity()));
        }
        catch (Exception e) {
            log.error("Failed to fetch institutional page details for ids: {}", institutionalPageIds, (Object)e);
            return institutionalPageIds.stream().collect(Collectors.toMap(id -> id, id -> OutputNewsInstitutionalPageDto.builder().id(id).build()));
        }
    }

    @NonNull
    private OutputNewsDetailDto buildAndEnrichNewsDetailDto(@NotNull OutputNewsDto outputNewsDto, Map<UUID, OutputNewsAuthorDto> userDetailByUserId, Map<UUID, OutputNewsInstitutionalPageDto> institutionalPageById) {
        OutputNewsDetailDto outputNewsDetailDto = this.buildNewsDetailDto(outputNewsDto);
        outputNewsDetailDto.setCreator(userDetailByUserId.get(outputNewsDto.getCreatorId()));
        List authors = this.getAuthors(outputNewsDto, userDetailByUserId);
        outputNewsDetailDto.setAuthors(authors);
        List institutionalPages = this.getInstitutionalPages(outputNewsDto, institutionalPageById);
        outputNewsDetailDto.setInstitutionalPages(institutionalPages);
        return outputNewsDetailDto;
    }

    private OutputNewsDetailDto buildNewsDetailDto(@NotNull OutputNewsDto newsDto) {
        return OutputNewsDetailDto.builder().id(newsDto.getId()).title(newsDto.getTitle()).newsType(newsDto.getNewsType()).content(newsDto.getContent()).tags(newsDto.getTags()).image(newsDto.getImage()).creationTime(newsDto.getCreationTime()).updateTime(newsDto.getUpdateTime()).build();
    }

    private OutputNewsAuthorDto buildNewsAuthorDto(@NotNull OutputAuthorDto authorDto) {
        return OutputNewsAuthorDto.builder().firstName(authorDto.getFirstName()).lastName(authorDto.getLastName()).orcid(authorDto.getOrcid()).email(authorDto.getEmail()).location(authorDto.getLocation()).build();
    }

    @NonNull
    private List<OutputNewsAuthorDto> getAuthors(@NotNull OutputNewsDto outputNewsDto, Map<UUID, OutputNewsAuthorDto> userDetailByUserId) {
        List<OutputNewsAuthorDto> registeredAuthors = outputNewsDto.getRegisteredAuthorIds().stream().map(s -> {
            UUID authorId = UUID.fromString(s);
            OutputNewsAuthorDto author = (OutputNewsAuthorDto)userDetailByUserId.get(authorId);
            if (author == null) {
                log.debug("News Author profile not found for ID: {}", (Object)authorId);
                author = OutputNewsAuthorDto.builder().id(authorId).build();
            }
            return author;
        }).filter(Objects::nonNull).toList();
        return Stream.concat(outputNewsDto.getUnRegisteredAuthors().stream().map(arg_0 -> this.buildNewsAuthorDto(arg_0)), registeredAuthors.stream()).toList();
    }

    @NonNull
    private List<OutputNewsInstitutionalPageDto> getInstitutionalPages(@NotNull OutputNewsDto outputNewsDto, Map<UUID, OutputNewsInstitutionalPageDto> institutionalPageById) {
        return outputNewsDto.getInstitutionalPages().stream().map(ipDto -> {
            OutputNewsInstitutionalPageDto institutionalPage = (OutputNewsInstitutionalPageDto)institutionalPageById.get(ipDto.getId());
            if (institutionalPage == null) {
                log.debug("News Institutional Page not found for ID: {}", (Object)ipDto.getId());
                institutionalPage = OutputNewsInstitutionalPageDto.builder().id(ipDto.getId()).name(ipDto.getName()).build();
            }
            return institutionalPage;
        }).filter(Objects::nonNull).toList();
    }

    @Generated
    public DefaultNewsService(NewsDmClient newsDmClient, NewsAuthorDetailProvider newsAuthorDetailProvider, NewsInstitutionalPageProvider newsInstitutionalPageProvider, ApplicationEventPublisher applicationEventPublisher) {
        this.newsDmClient = newsDmClient;
        this.newsAuthorDetailProvider = newsAuthorDetailProvider;
        this.newsInstitutionalPageProvider = newsInstitutionalPageProvider;
        this.applicationEventPublisher = applicationEventPublisher;
    }
}

