package com.finconsgroup.itserr.marketplace.news.dm.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

import java.util.UUID;

import static com.finconsgroup.itserr.marketplace.news.dm.util.ValidationConstants.VALIDATION_ERROR_FIELD_LENGTH;
import static com.finconsgroup.itserr.marketplace.news.dm.util.ValidationConstants.VALIDATION_ERROR_REQUIRED_FIELD;
import static com.finconsgroup.itserr.marketplace.news.dm.util.ValidationConstants.VALIDATION_LOCATION_LENGTH;

/**
 * Output DTO response for an Institutional Page.
 */
@Schema(name = "OutputInstitutionalPageDto", description = "DTO response for an Institutional Page")
@Data
@Builder
@AllArgsConstructor
public class OutputInstitutionalPageDto {

    @Schema(description = "ID of the Institutional Page", example = "123e4567-e89b-12d3-a456-426614174002")
    private UUID id;

    @Schema(description = "Name of Institutional Page", example = "WP3 - T-Res")
    private String name;
}

