package com.finconsgroup.itserr.marketplace.news.dm.entity;

import com.finconsgroup.itserr.marketplace.core.entity.AbstractUUIDEntity;
import com.finconsgroup.itserr.marketplace.news.dm.entity.converter.StringListConverter;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.Lob;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

import java.time.Instant;
import java.util.List;
import java.util.UUID;

import static com.finconsgroup.itserr.marketplace.news.dm.entity.NewsEntity.CONTENT_LENGTH;
import static com.finconsgroup.itserr.marketplace.news.dm.entity.NewsEntity.TITLE_LENGTH;
import static com.finconsgroup.itserr.marketplace.news.dm.entity.NewsEntity.TYPE_LENGTH;

/**
 * This entity represents a soft deleted {@link NewsEntity}.
 * But it doesn't have unique constraints on name field.
 */
@Entity
@Table(name = "archived_author")
@Data
@SuperBuilder
@EqualsAndHashCode(callSuper = true)
@NoArgsConstructor
public class ArchivedAuthorEntity extends AbstractUUIDEntity {

    @EqualsAndHashCode.Exclude
    @ManyToOne
    @JoinColumn(name = "news_id", nullable = false)
    private ArchivedNewsEntity archivedNews;

    @Column(name = "first_name", nullable = false)
    private String firstName;

    @Column(name = "last_name", nullable = false)
    private String lastName;

    @Column(name = "email", nullable = false)
    private String email;

    @Column(name = "orcid")
    private String orcid;

    @Column(name = "location_city")
    private String locationCity;

    @Column(name = "location_region")
    private String locationRegion;

    @Column(name = "location_country")
    private String locationCountry;

    @Column(name = "location_zip_code")
    private String locationZipCode;

    @Column(name = "creation_time", nullable = false, updatable = false)
    private Instant creationTime;

    @Column(name = "update_time", nullable = false)
    private Instant updateTime;

    @Column(name = "version", nullable = false)
    private long version;

    @Override
    public void prePersist() {
        super.prePersist();
        Instant now = Instant.now();
        if (creationTime == null) {
            creationTime = now;
        }
        if (updateTime == null) {
            updateTime = now;
        }
    }

}
