/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.news.dm.entity;

import com.finconsgroup.itserr.marketplace.core.entity.AbstractUUIDEntity;
import com.finconsgroup.itserr.marketplace.news.dm.entity.AuthorEntity;
import com.finconsgroup.itserr.marketplace.news.dm.entity.NewsEntity;
import com.finconsgroup.itserr.marketplace.news.dm.entity.converter.StringListConverter;
import com.finconsgroup.itserr.marketplace.news.dm.model.InstitutionalPageModel;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.Lob;
import jakarta.persistence.OneToMany;
import jakarta.persistence.PreUpdate;
import jakarta.persistence.Table;
import jakarta.persistence.Version;
import java.time.Instant;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.hibernate.annotations.JdbcTypeCode;

@Entity
@Table(name="news")
public class NewsEntity
extends AbstractUUIDEntity {
    public static final int TITLE_LENGTH = 200;
    public static final int TYPE_LENGTH = 50;
    public static final int CONTENT_LENGTH = 8000;
    @Column(name="title", nullable=false, length=200)
    private String title;
    @Column(name="creator_id", nullable=false)
    private UUID creatorId;
    @Column(name="news_type", length=50)
    private String newsType;
    @Column(name="content", length=8000)
    private String content;
    @Lob
    @Convert(converter=StringListConverter.class)
    @Column(name="tags")
    private List<String> tags;
    @JdbcTypeCode(value=3001)
    @Column(name="institutional_pages", columnDefinition="json")
    private List<InstitutionalPageModel> institutionalPages;
    @Column(name="image_id")
    private UUID imageId;
    @Column(name="image_url")
    private String imageUrl;
    @Lob
    @Convert(converter=StringListConverter.class)
    @Column(name="registered_author_ids")
    private List<String> registeredAuthorIds;
    @OneToMany(mappedBy="news", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<AuthorEntity> unRegisteredAuthors;
    @Column(name="creation_time", nullable=false, updatable=false)
    private Instant creationTime;
    @Column(name="update_time", nullable=false)
    private Instant updateTime;
    @Version
    @Column(name="version", nullable=false)
    private long version;

    public void prePersist() {
        super.prePersist();
        Instant now = Instant.now();
        if (this.creationTime == null) {
            this.creationTime = now;
        }
        if (this.updateTime == null) {
            this.updateTime = now;
        }
    }

    @PreUpdate
    public void onUpdate() {
        this.updateTime = Instant.now();
    }

    @Generated
    protected NewsEntity(NewsEntityBuilder<?, ?> b) {
        super(b);
        this.title = b.title;
        this.creatorId = b.creatorId;
        this.newsType = b.newsType;
        this.content = b.content;
        this.tags = b.tags;
        this.institutionalPages = b.institutionalPages;
        this.imageId = b.imageId;
        this.imageUrl = b.imageUrl;
        this.registeredAuthorIds = b.registeredAuthorIds;
        this.unRegisteredAuthors = b.unRegisteredAuthors;
        this.creationTime = b.creationTime;
        this.updateTime = b.updateTime;
        this.version = b.version;
    }

    @Generated
    public static NewsEntityBuilder<?, ?> builder() {
        return new NewsEntityBuilderImpl();
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public UUID getCreatorId() {
        return this.creatorId;
    }

    @Generated
    public String getNewsType() {
        return this.newsType;
    }

    @Generated
    public String getContent() {
        return this.content;
    }

    @Generated
    public List<String> getTags() {
        return this.tags;
    }

    @Generated
    public List<InstitutionalPageModel> getInstitutionalPages() {
        return this.institutionalPages;
    }

    @Generated
    public UUID getImageId() {
        return this.imageId;
    }

    @Generated
    public String getImageUrl() {
        return this.imageUrl;
    }

    @Generated
    public List<String> getRegisteredAuthorIds() {
        return this.registeredAuthorIds;
    }

    @Generated
    public List<AuthorEntity> getUnRegisteredAuthors() {
        return this.unRegisteredAuthors;
    }

    @Generated
    public Instant getCreationTime() {
        return this.creationTime;
    }

    @Generated
    public Instant getUpdateTime() {
        return this.updateTime;
    }

    @Generated
    public long getVersion() {
        return this.version;
    }

    @Generated
    public void setTitle(String title) {
        this.title = title;
    }

    @Generated
    public void setCreatorId(UUID creatorId) {
        this.creatorId = creatorId;
    }

    @Generated
    public void setNewsType(String newsType) {
        this.newsType = newsType;
    }

    @Generated
    public void setContent(String content) {
        this.content = content;
    }

    @Generated
    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    @Generated
    public void setInstitutionalPages(List<InstitutionalPageModel> institutionalPages) {
        this.institutionalPages = institutionalPages;
    }

    @Generated
    public void setImageId(UUID imageId) {
        this.imageId = imageId;
    }

    @Generated
    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    @Generated
    public void setRegisteredAuthorIds(List<String> registeredAuthorIds) {
        this.registeredAuthorIds = registeredAuthorIds;
    }

    @Generated
    public void setUnRegisteredAuthors(List<AuthorEntity> unRegisteredAuthors) {
        this.unRegisteredAuthors = unRegisteredAuthors;
    }

    @Generated
    public void setCreationTime(Instant creationTime) {
        this.creationTime = creationTime;
    }

    @Generated
    public void setUpdateTime(Instant updateTime) {
        this.updateTime = updateTime;
    }

    @Generated
    public void setVersion(long version) {
        this.version = version;
    }

    @Generated
    public String toString() {
        return "NewsEntity(title=" + this.getTitle() + ", creatorId=" + String.valueOf(this.getCreatorId()) + ", newsType=" + this.getNewsType() + ", content=" + this.getContent() + ", tags=" + String.valueOf(this.getTags()) + ", institutionalPages=" + String.valueOf(this.getInstitutionalPages()) + ", imageId=" + String.valueOf(this.getImageId()) + ", imageUrl=" + this.getImageUrl() + ", registeredAuthorIds=" + String.valueOf(this.getRegisteredAuthorIds()) + ", unRegisteredAuthors=" + String.valueOf(this.getUnRegisteredAuthors()) + ", creationTime=" + String.valueOf(this.getCreationTime()) + ", updateTime=" + String.valueOf(this.getUpdateTime()) + ", version=" + this.getVersion() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NewsEntity)) {
            return false;
        }
        NewsEntity other = (NewsEntity)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getVersion() != other.getVersion()) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        UUID this$creatorId = this.getCreatorId();
        UUID other$creatorId = other.getCreatorId();
        if (this$creatorId == null ? other$creatorId != null : !((Object)this$creatorId).equals(other$creatorId)) {
            return false;
        }
        String this$newsType = this.getNewsType();
        String other$newsType = other.getNewsType();
        if (this$newsType == null ? other$newsType != null : !this$newsType.equals(other$newsType)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        List this$tags = this.getTags();
        List other$tags = other.getTags();
        if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
            return false;
        }
        List this$institutionalPages = this.getInstitutionalPages();
        List other$institutionalPages = other.getInstitutionalPages();
        if (this$institutionalPages == null ? other$institutionalPages != null : !((Object)this$institutionalPages).equals(other$institutionalPages)) {
            return false;
        }
        UUID this$imageId = this.getImageId();
        UUID other$imageId = other.getImageId();
        if (this$imageId == null ? other$imageId != null : !((Object)this$imageId).equals(other$imageId)) {
            return false;
        }
        String this$imageUrl = this.getImageUrl();
        String other$imageUrl = other.getImageUrl();
        if (this$imageUrl == null ? other$imageUrl != null : !this$imageUrl.equals(other$imageUrl)) {
            return false;
        }
        List this$registeredAuthorIds = this.getRegisteredAuthorIds();
        List other$registeredAuthorIds = other.getRegisteredAuthorIds();
        if (this$registeredAuthorIds == null ? other$registeredAuthorIds != null : !((Object)this$registeredAuthorIds).equals(other$registeredAuthorIds)) {
            return false;
        }
        List this$unRegisteredAuthors = this.getUnRegisteredAuthors();
        List other$unRegisteredAuthors = other.getUnRegisteredAuthors();
        if (this$unRegisteredAuthors == null ? other$unRegisteredAuthors != null : !((Object)this$unRegisteredAuthors).equals(other$unRegisteredAuthors)) {
            return false;
        }
        Instant this$creationTime = this.getCreationTime();
        Instant other$creationTime = other.getCreationTime();
        if (this$creationTime == null ? other$creationTime != null : !((Object)this$creationTime).equals(other$creationTime)) {
            return false;
        }
        Instant this$updateTime = this.getUpdateTime();
        Instant other$updateTime = other.getUpdateTime();
        return !(this$updateTime == null ? other$updateTime != null : !((Object)this$updateTime).equals(other$updateTime));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof NewsEntity;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $version = this.getVersion();
        result = result * 59 + (int)($version >>> 32 ^ $version);
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        UUID $creatorId = this.getCreatorId();
        result = result * 59 + ($creatorId == null ? 43 : ((Object)$creatorId).hashCode());
        String $newsType = this.getNewsType();
        result = result * 59 + ($newsType == null ? 43 : $newsType.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        List $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        List $institutionalPages = this.getInstitutionalPages();
        result = result * 59 + ($institutionalPages == null ? 43 : ((Object)$institutionalPages).hashCode());
        UUID $imageId = this.getImageId();
        result = result * 59 + ($imageId == null ? 43 : ((Object)$imageId).hashCode());
        String $imageUrl = this.getImageUrl();
        result = result * 59 + ($imageUrl == null ? 43 : $imageUrl.hashCode());
        List $registeredAuthorIds = this.getRegisteredAuthorIds();
        result = result * 59 + ($registeredAuthorIds == null ? 43 : ((Object)$registeredAuthorIds).hashCode());
        List $unRegisteredAuthors = this.getUnRegisteredAuthors();
        result = result * 59 + ($unRegisteredAuthors == null ? 43 : ((Object)$unRegisteredAuthors).hashCode());
        Instant $creationTime = this.getCreationTime();
        result = result * 59 + ($creationTime == null ? 43 : ((Object)$creationTime).hashCode());
        Instant $updateTime = this.getUpdateTime();
        result = result * 59 + ($updateTime == null ? 43 : ((Object)$updateTime).hashCode());
        return result;
    }

    @Generated
    public NewsEntity() {
    }
}

