package com.finconsgroup.itserr.marketplace.notification.bs.event;

import lombok.Builder;
import lombok.Data;

import java.util.UUID;

/**
 * Event class representing the creation of a new notification. This event is published when a new notification is created.
 */
@Data
@Builder
public class NotificationCreatedEvent {

    /**
     * Unique identifier of the user notification
     */
    private UUID id;

    /**
     * The user the notification is sent to, expressed as an id, a username or an email.
     */
    private String user;

}
