package com.finconsgroup.itserr.marketplace.notification.bs.websocket.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Builder;
import lombok.Data;

import java.time.ZonedDateTime;
import java.util.UUID;

/**
 * DTO representing the creation of a new notification and used to send it through websocket.
 */
@Data
@Builder
public class NotificationCreatedWsDto {

    /**
     * Unique identifier of the user notification
     */
    private UUID id;

    /**
     * The type of notification
     */
    private String type;

    /**
     * The notification message
     */
    private String message;

    /**
     * ID of the referenced entity
     */
    private String referencedId;

    /**
     * The creation time of the notification.
     */
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ssXXX")
    private ZonedDateTime creationTime;

}
