/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.notification.bs.api;

import com.finconsgroup.itserr.marketplace.core.web.exception.ErrorResponseDto;
import com.finconsgroup.itserr.marketplace.notification.bs.client.dto.InputCreateUserNotificationDto;
import com.finconsgroup.itserr.marketplace.notification.bs.client.dto.OutputUserNotificationDto;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.util.List;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Tag(name="Diagnostics", description="Diagnostics API: provides endpoints used for debugging and runtime analysis.")
@SecurityRequirement(name="BearerAuth")
public interface DiagnosticsApi {
    @Operation(summary="Download log file", responses={@ApiResponse(responseCode="200", description="OK")})
    @GetMapping(path={"/notification/diagnostics/download-logs"}, produces={"application/octet-stream"})
    public ResponseEntity<Resource> downloadLogs();

    @Operation(summary="diagnose create user notification api", responses={@ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="503", description="Service unavailable", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponseDto.class))})})
    @PostMapping(value={"/notification/diagnostics/notifications"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public List<OutputUserNotificationDto> createNotification(@Valid @RequestBody InputCreateUserNotificationDto var1);
}

