/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.notification.bs.websocket;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.finconsgroup.itserr.marketplace.notification.bs.client.NotificationInternalDmClient;
import com.finconsgroup.itserr.marketplace.notification.bs.client.dto.OutputLocalizedUserNotificationDto;
import com.finconsgroup.itserr.marketplace.notification.bs.event.NotificationCreatedEvent;
import com.finconsgroup.itserr.marketplace.notification.bs.mapper.NotificationMapper;
import com.finconsgroup.itserr.marketplace.notification.bs.websocket.NotificationsWebSocketHandler;
import com.finconsgroup.itserr.marketplace.notification.bs.websocket.WebSocketSessionInfo;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.lang.NonNull;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class NotificationWebsocketPublisher {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NotificationWebsocketPublisher.class);
    private final NotificationInternalDmClient notificationInternalDmClient;
    private final NotificationsWebSocketHandler notificationsWebSocketHandler;
    private final NotificationMapper notificationMapper;
    private final ObjectMapper objectMapper;

    @Async
    @EventListener
    public void onNotificationCreated(@NonNull NotificationCreatedEvent event) {
        log.debug("Publishing notification {} to websockets", (Object)event.getId());
        this.notificationsWebSocketHandler.sendNoThrow(event.getUser(), session -> this.buildMessage(event, session));
    }

    private String buildMessage(@NonNull NotificationCreatedEvent event, @NonNull WebSocketSessionInfo session) {
        OutputLocalizedUserNotificationDto notification = this.notificationInternalDmClient.findById(event.getId(), session.acceptLanguage());
        try {
            return this.objectMapper.writeValueAsString((Object)this.notificationMapper.toWsDto(notification));
        }
        catch (Exception e) {
            throw new IllegalStateException("Error serializing notification", e);
        }
    }

    @Generated
    public NotificationWebsocketPublisher(NotificationInternalDmClient notificationInternalDmClient, NotificationsWebSocketHandler notificationsWebSocketHandler, NotificationMapper notificationMapper, ObjectMapper objectMapper) {
        this.notificationInternalDmClient = notificationInternalDmClient;
        this.notificationsWebSocketHandler = notificationsWebSocketHandler;
        this.notificationMapper = notificationMapper;
        this.objectMapper = objectMapper;
    }
}

