package com.finconsgroup.itserr.marketplace.notification.dm.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

import java.util.List;
import java.util.Map;

import static com.finconsgroup.itserr.marketplace.notification.dm.util.Constants.VALIDATION_ERROR_FIELD_LENGTH;
import static com.finconsgroup.itserr.marketplace.notification.dm.util.Constants.VALIDATION_ERROR_NON_EMPTY_FIELD;
import static com.finconsgroup.itserr.marketplace.notification.dm.util.Constants.VALIDATION_ERROR_REQUIRED_FIELD;

/**
 * Input DTO for creating a user notification.
 */
@Schema(name = "InputCreateUserNotificationDto", description = "DTO for creating a user notification")
@Data
@Builder
@AllArgsConstructor
public class InputCreateUserNotificationDto {

    @Schema(description = "The users receiving the notification, represented as an UID, an username or an email", example = "f81d4fae-7dec-11d0-a765-00a0c91e6bf6")
    @NotNull(message = VALIDATION_ERROR_REQUIRED_FIELD)
    @NotEmpty(message = VALIDATION_ERROR_NON_EMPTY_FIELD)
    private List<String> users;

    @Schema(description = "The type of notification", example = "catalog-item-event-created")
    @NotBlank(message = VALIDATION_ERROR_REQUIRED_FIELD)
    @Size(max = 100, message = VALIDATION_ERROR_FIELD_LENGTH)
    private String type;

    @Schema(description = "ID of the referenced entity", example = "12345")
    @NotBlank(message = VALIDATION_ERROR_REQUIRED_FIELD)
    @Size(max = 100, message = VALIDATION_ERROR_FIELD_LENGTH)
    private String referencedId;

    @Schema(description = "Placeholder values for notification template")
    private Map<String, String> placeholderValues;
}
