package com.finconsgroup.itserr.marketplace.notification.dm.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

import java.time.ZonedDateTime;
import java.util.Map;
import java.util.UUID;

/**
 * Output DTO representing a created user notification.
 */
@Schema(name = "OutputUserNotificationDto", description = "DTO representing a user notification in responses")
@Data
@Builder
@AllArgsConstructor
public class OutputUserNotificationDto {

    @Schema(description = "Unique identifier of the user notification", example = "550e8400-e29b-41d4-a716-446655440000")
    private UUID id;

    @Schema(description = "The user receiving the notification, represented as an UID, an username or an email", example = "f81d4fae-7dec-11d0-a765-00a0c91e6bf6")
    private String user;

    @Schema(description = "The type of notification", example = "catalog-item-event-created")
    private String type;

    @Schema(description = "ID of the referenced entity", example = "12345")
    private String referencedId;

    @Schema(description = "Placeholder values for notification template")
    private Map<String, String> placeholderValues;

    @Schema(description = "Flag indicating whether the notification has been read")
    private Boolean read;

    @Schema(description = "Flag indicating whether the notification has been archived")
    private Boolean archived;

    @Schema(description = "The last read time of the user notification", example = "2025-04-06T10:15:30+01:00")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ssXXX")
    private ZonedDateTime lastReadTime;

    @Schema(description = "The creation time of the table record", example = "2025-04-06T10:15:30+01:00")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ssXXX")
    private ZonedDateTime creationTime;

    @Schema(description = "The last update time of the table record", example = "2025-04-06T10:15:30+01:00")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ssXXX")
    private ZonedDateTime updateTime;

}
