package com.finconsgroup.itserr.marketplace.notification.dm.mapper;

import com.finconsgroup.itserr.marketplace.notification.dm.dto.OutputNotificationEmailTemplateDto;
import com.finconsgroup.itserr.marketplace.notification.dm.entity.NotificationEmailTemplateEntity;
import org.mapstruct.Mapper;

/**
 * Mapper interface for converting between {@link NotificationEmailTemplateEntity} and {@link OutputNotificationEmailTemplateDto}.
 */
@Mapper(config = MapperConfiguration.class)
public interface NotificationEmailTemplateMapper {

    /**
     * Converts a {@link NotificationEmailTemplateEntity} to {@link OutputNotificationEmailTemplateDto}.
     *
     * @param entity the notification email template entity to convert
     * @return the converted output notification email template DTO
     */
    OutputNotificationEmailTemplateDto toDto(NotificationEmailTemplateEntity entity);

}
