package com.finconsgroup.itserr.marketplace.notification.dm.repository;

import com.finconsgroup.itserr.marketplace.notification.dm.entity.NotificationTemplateEntity;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Repository;

import java.util.Optional;
import java.util.UUID;

/**
 * {@link NotificationTemplateEntity} repository.
 */
@Repository
public interface NotificationTemplateRepository extends JpaRepository<NotificationTemplateEntity, UUID> {

    /**
     * Finds a notification template entity by its notification type and language code.
     *
     * @param notificationType the type of notification used to identify the template (e.g., "catalog-item-event-created").
     * @param languageCode the ISO 639-1 two-letter code representing the language of the template (e.g., "en", "fr").
     * @return an {@link Optional} containing the matching {@link NotificationTemplateEntity} if found, or an empty {@link Optional} if no match exists.
     */
    Optional<NotificationTemplateEntity> findByNotificationTypeAndLanguageCode(
            String notificationType,
            String languageCode);

}
