/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.notification.dm.mapper;

import com.finconsgroup.itserr.marketplace.notification.dm.dto.OutputLocalizedUserNotificationDto;
import com.finconsgroup.itserr.marketplace.notification.dm.entity.UserNotificationEntity;
import com.finconsgroup.itserr.marketplace.notification.dm.mapper.MapperConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.mapstruct.Context;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;

@Mapper(config=MapperConfiguration.class)
public interface LocalizedUserNotificationMapper {
    public static final Pattern PLACEHOLDER_PATTERN = Pattern.compile("\\{\\{(.+?)\\}\\}");

    @Mapping(target="message", expression="java(resolveMessage(message, userNotificationEntity.getPlaceholderValues()))")
    public OutputLocalizedUserNotificationDto toDto(UserNotificationEntity var1, @Context String var2);

    default public String resolveMessage(String message, @Context Map<String, String> placeholders) {
        HashMap<String, String> actualPlaceholders = placeholders != null ? new HashMap<String, String>(placeholders) : new HashMap();
        return PLACEHOLDER_PATTERN.matcher(message).replaceAll(mr -> actualPlaceholders.getOrDefault(mr.group(1), mr.group(0)));
    }
}

