package com.finconsgroup.itserr.marketplace.notificationfeeder.bs.config.properties;

import com.finconsgroup.itserr.messaging.autoconfigure.MessagingDlqProperties;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.validation.annotation.Validated;

/**
 * Properties configuration class for bus consumer settings.
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@Validated
public class BusConsumerProperties {

    /** Dead letter queue configuration properties for message handling */
    @NotNull
    @Valid
    private MessagingDlqProperties dlq;

}
