package com.finconsgroup.itserr.marketplace.notificationfeeder.bs.config.properties;

import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.lang.NonNull;
import org.springframework.validation.annotation.Validated;

import java.util.HashMap;
import java.util.Map;

/**
 * Configuration properties class for bus driver settings that manages consumer properties and notification configurations.
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@Validated
public class BusDriverProperties {

    /** Configuration properties for the bus consumer settings */
    @Valid
    @NotNull
    private BusConsumerProperties consumer;

    /** Map of notification configurations indexed by their identifiers */
    @NonNull
    @Valid
    @Builder.Default
    private Map<String, BusNotificationProperties> notifications = new HashMap<>();

}
