package com.finconsgroup.itserr.marketplace.notificationfeeder.bs.event;

import com.finconsgroup.itserr.messaging.consumer.handler.ConsumerMessageHandler;
import org.springframework.lang.NonNull;

/**
 * Interface for handling notification-specific consumer messages. Extends the base {@link ConsumerMessageHandler} to provide notification-specific
 * functionality.
 */
public interface NotificationConsumerMessageHandler extends ConsumerMessageHandler {

    /**
     * Retrieves the name identifier for this notification handler.
     *
     * @return the name of the notification handler
     */
    @NonNull
    String getName();

    /**
     * Gets the type of notification this handler is responsible for processing.
     *
     * @return the notification type
     */
    @NonNull
    String getNotificationType();

}
